/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.management.entitlement;

import brooklyn.config.BrooklynProperties;
import brooklyn.config.ConfigKey;
import brooklyn.config.ConfigPredicates;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.management.entitlement.EntitlementClass;
import brooklyn.management.entitlement.EntitlementContext;
import brooklyn.management.entitlement.EntitlementManager;
import brooklyn.management.entitlement.Entitlements;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.text.Strings;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerUserEntitlementManager
implements EntitlementManager {
    private static final Logger log = LoggerFactory.getLogger(PerUserEntitlementManager.class);
    public static final String PER_USER_ENTITLEMENTS_CONFIG_PREFIX = "brooklyn.entitlements.perUser";
    public static final ConfigKey<String> DEFAULT_MANAGER = ConfigKeys.newStringConfigKey("brooklyn.entitlements.perUser.default", "Default entitlements manager for users without further specification", "minimal");
    protected final EntitlementManager defaultManager;
    protected final Map<String, EntitlementManager> perUserManagers = MutableMap.of();
    private static final ThreadLocal<Boolean> ACTIVE = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static EntitlementManager load(BrooklynProperties properties, String type) {
        if (Boolean.TRUE.equals(ACTIVE.get())) {
            throw new IllegalStateException("Cannot set " + PerUserEntitlementManager.class.getName() + " within config for itself");
        }
        try {
            ACTIVE.set(true);
            EntitlementManager entitlementManager = Entitlements.load(null, properties, type);
            return entitlementManager;
        }
        finally {
            ACTIVE.remove();
        }
    }

    public PerUserEntitlementManager(BrooklynProperties properties) {
        this(PerUserEntitlementManager.load(properties, properties.getConfig(DEFAULT_MANAGER)));
        BrooklynProperties users = properties.submap(ConfigPredicates.startingWith("brooklyn.entitlements.perUser."));
        for (Map.Entry<ConfigKey<?>, Object> key : users.getAllConfig().entrySet()) {
            if (key.getKey().getName().equals(DEFAULT_MANAGER.getName())) continue;
            String user = Strings.removeFromStart((String)key.getKey().getName(), (String)"brooklyn.entitlements.perUser.");
            this.addUser(user, PerUserEntitlementManager.load(properties, Strings.toString((Object)key.getValue())));
        }
        log.info(this.getClass().getSimpleName() + " created with " + this.perUserManagers.size() + " user" + Strings.s(this.perUserManagers) + " and " + "default " + this.defaultManager + " (users: " + this.perUserManagers + ")");
    }

    public PerUserEntitlementManager(EntitlementManager defaultManager) {
        this.defaultManager = (EntitlementManager)Preconditions.checkNotNull((Object)defaultManager);
    }

    public void addUser(String user, EntitlementManager managerForThisUser) {
        this.perUserManagers.put((String)Preconditions.checkNotNull((Object)user, (Object)"user"), (EntitlementManager)Preconditions.checkNotNull((Object)managerForThisUser, (Object)"managerForThisUser"));
    }

    public <T> boolean isEntitled(EntitlementContext context, EntitlementClass<T> entitlementClass, T entitlementClassArgument) {
        EntitlementManager entitlementInEffect = null;
        if (context == null || context.user() == null) {
            entitlementInEffect = Entitlements.root();
        } else {
            if (context != null) {
                entitlementInEffect = this.perUserManagers.get(context.user());
            }
            if (entitlementInEffect == null) {
                entitlementInEffect = this.defaultManager;
            }
        }
        return entitlementInEffect.isEntitled(context, entitlementClass, entitlementClassArgument);
    }
}

