/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.management.classloading;

import brooklyn.catalog.CatalogItem;
import brooklyn.catalog.internal.CatalogUtils;
import brooklyn.management.ManagementContext;
import brooklyn.management.classloading.AbstractBrooklynClassLoadingContext;
import brooklyn.management.entitlement.Entitlements;
import brooklyn.management.ha.OsgiManager;
import brooklyn.management.internal.ManagementContextInternal;
import brooklyn.util.guava.Maybe;
import com.google.common.base.Objects;
import java.net.URL;
import java.util.Collection;

public class OsgiBrooklynClassLoadingContext
extends AbstractBrooklynClassLoadingContext {
    private final String catalogItemId;
    private boolean hasBundles = false;
    private transient Collection<CatalogItem.CatalogBundle> _bundles;

    public OsgiBrooklynClassLoadingContext(ManagementContext mgmt, String catalogItemId, Collection<CatalogItem.CatalogBundle> bundles) {
        super(mgmt);
        this._bundles = bundles;
        this.hasBundles = bundles != null && !bundles.isEmpty();
        this.catalogItemId = catalogItemId;
    }

    public Collection<CatalogItem.CatalogBundle> getBundles() {
        if (this._bundles != null || !this.hasBundles) {
            return this._bundles;
        }
        CatalogItem<?, ?> cat = CatalogUtils.getCatalogItemOptionalVersion(this.mgmt, this.catalogItemId);
        if (cat == null) {
            throw new IllegalStateException("Catalog item not found for " + this.catalogItemId + "; cannot create loading context");
        }
        this._bundles = cat.getLibraries();
        return this._bundles;
    }

    @Override
    public Maybe<Class<?>> tryLoadClass(String className) {
        Maybe clazz = null;
        Maybe<OsgiManager> osgi = null;
        if (this.mgmt != null && (osgi = ((ManagementContextInternal)this.mgmt).getOsgiManager()).isPresent() && this.getBundles() != null && !this.getBundles().isEmpty()) {
            if (!Entitlements.isEntitled(this.mgmt.getEntitlementManager(), Entitlements.SEE_CATALOG_ITEM, this.catalogItemId)) {
                return Maybe.absent((String)"Not entitled to use this catalog entry");
            }
            clazz = ((OsgiManager)osgi.get()).tryResolveClass(className, this.getBundles());
            if (clazz.isPresent()) {
                return clazz;
            }
        }
        if (clazz != null) {
            return clazz;
        }
        if (this.mgmt == null) {
            return Maybe.absent((String)("No mgmt context available for loading " + className));
        }
        if (osgi != null && osgi.isAbsent()) {
            return Maybe.absent((String)("OSGi not available on mgmt for loading " + className));
        }
        if (!this.hasBundles) {
            return Maybe.absent((String)("No bundles available for loading " + className));
        }
        return Maybe.absent((String)("Inconsistent state (" + this.mgmt + "/" + osgi + "/" + this.getBundles() + " loading " + className));
    }

    @Override
    public String toString() {
        return "OSGi:" + this.catalogItemId + "[" + this.getBundles() + "]";
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.getBundles(), this.catalogItemId});
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OsgiBrooklynClassLoadingContext)) {
            return false;
        }
        OsgiBrooklynClassLoadingContext other = (OsgiBrooklynClassLoadingContext)obj;
        if (!this.catalogItemId.equals(other.catalogItemId)) {
            return false;
        }
        return Objects.equal(this.getBundles(), other.getBundles());
    }

    public URL getResource(String name) {
        Maybe<OsgiManager> osgi;
        if (this.mgmt != null && (osgi = ((ManagementContextInternal)this.mgmt).getOsgiManager()).isPresent() && this.hasBundles) {
            return ((OsgiManager)osgi.get()).getResource(name, this.getBundles());
        }
        return null;
    }

    public String getCatalogItemId() {
        return this.catalogItemId;
    }
}

