/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.management.classloading;

import brooklyn.management.ManagementContext;
import brooklyn.management.classloading.AbstractBrooklynClassLoadingContext;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.guava.Maybe;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.net.URL;

public class JavaBrooklynClassLoadingContext
extends AbstractBrooklynClassLoadingContext {
    private final transient ClassLoader loader;

    @Deprecated
    public static JavaBrooklynClassLoadingContext create(ClassLoader loader) {
        return new JavaBrooklynClassLoadingContext(null, (ClassLoader)Preconditions.checkNotNull((Object)loader, (Object)"loader"));
    }

    @Deprecated
    public static JavaBrooklynClassLoadingContext create(ManagementContext mgmt, ClassLoader loader) {
        Preconditions.checkState((mgmt != null || loader != null ? 1 : 0) != 0, (Object)"mgmt and loader must not both be null");
        return new JavaBrooklynClassLoadingContext(mgmt, loader);
    }

    public static JavaBrooklynClassLoadingContext create(ManagementContext mgmt) {
        return new JavaBrooklynClassLoadingContext((ManagementContext)Preconditions.checkNotNull((Object)mgmt, (Object)"mgmt"), null);
    }

    @Deprecated
    public static JavaBrooklynClassLoadingContext newDefault(ManagementContext mgmt) {
        return new JavaBrooklynClassLoadingContext((ManagementContext)Preconditions.checkNotNull((Object)mgmt, (Object)"mgmt"), null);
    }

    @Deprecated
    public JavaBrooklynClassLoadingContext(ManagementContext mgmt, ClassLoader loader) {
        super(mgmt);
        this.loader = loader;
    }

    private ClassLoader getClassLoader() {
        if (this.loader != null) {
            return this.loader;
        }
        if (this.mgmt != null) {
            return this.mgmt.getCatalogClassLoader();
        }
        return JavaBrooklynClassLoadingContext.class.getClassLoader();
    }

    @Override
    public Maybe<Class<?>> tryLoadClass(String className) {
        try {
            return Maybe.of(this.getClassLoader().loadClass(className));
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            return Maybe.absent((String)("Invalid class: " + className), (Throwable)e);
        }
    }

    @Override
    public String toString() {
        return "java:" + this.getClassLoader();
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.getClassLoader()});
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof JavaBrooklynClassLoadingContext)) {
            return false;
        }
        return Objects.equal((Object)this.getClassLoader(), (Object)((JavaBrooklynClassLoadingContext)obj).getClassLoader());
    }

    public URL getResource(String name) {
        return this.getClassLoader().getResource(name);
    }
}

