/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.management.classloading;

import brooklyn.management.classloading.BrooklynClassLoadingContext;
import java.net.URL;

public class ClassLoaderFromBrooklynClassLoadingContext
extends ClassLoader {
    protected final BrooklynClassLoadingContext clc;

    public static ClassLoader of(BrooklynClassLoadingContext clc) {
        return new ClassLoaderFromBrooklynClassLoadingContext(clc);
    }

    protected ClassLoaderFromBrooklynClassLoadingContext(BrooklynClassLoadingContext clc) {
        this.clc = clc;
    }

    @Override
    public Class<?> findClass(String className) throws ClassNotFoundException {
        Class<?> result = this.clc.loadClass(className);
        if (result != null) {
            return result;
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null && (result = contextClassLoader.loadClass(className)) != null) {
            return result;
        }
        return null;
    }

    @Override
    protected URL findResource(String name) {
        URL result = this.clc.getResource(name);
        if (result != null) {
            return result;
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null && (result = contextClassLoader.getResource(name)) != null) {
            return result;
        }
        return null;
    }
}

