/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.management.classloading;

import brooklyn.management.ManagementContext;
import brooklyn.management.classloading.AbstractBrooklynClassLoadingContext;
import brooklyn.management.classloading.BrooklynClassLoadingContext;
import brooklyn.management.classloading.JavaBrooklynClassLoadingContext;
import brooklyn.util.collections.MutableList;
import brooklyn.util.collections.MutableSet;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.guava.Maybe;
import com.google.common.base.Objects;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BrooklynClassLoadingContextSequential
extends AbstractBrooklynClassLoadingContext {
    private static final Logger log = LoggerFactory.getLogger(BrooklynClassLoadingContextSequential.class);
    private final List<BrooklynClassLoadingContext> primaries = MutableList.of();
    private final Set<BrooklynClassLoadingContext> secondaries = MutableSet.of();

    public BrooklynClassLoadingContextSequential(ManagementContext mgmt, BrooklynClassLoadingContext ... targets) {
        super(mgmt);
        for (BrooklynClassLoadingContext target : targets) {
            this.add(target);
        }
    }

    public void add(BrooklynClassLoadingContext target) {
        if (target instanceof BrooklynClassLoadingContextSequential) {
            for (BrooklynClassLoadingContext targetN : ((BrooklynClassLoadingContextSequential)target).primaries) {
                this.add(targetN);
            }
            for (BrooklynClassLoadingContext targetN : ((BrooklynClassLoadingContextSequential)target).secondaries) {
                this.addSecondary(targetN);
            }
        } else {
            this.primaries.add(target);
        }
    }

    public void addSecondary(BrooklynClassLoadingContext target) {
        if (!(target instanceof JavaBrooklynClassLoadingContext)) {
            log.warn("Only Java classloaders should be secondary");
        }
        this.secondaries.add(target);
    }

    @Override
    public Maybe<Class<?>> tryLoadClass(String className) {
        MutableList errors = MutableList.of();
        for (BrooklynClassLoadingContext target : this.primaries) {
            Maybe clazz = target.tryLoadClass(className);
            if (clazz.isPresent()) {
                return clazz;
            }
            errors.add(((Maybe.Absent)clazz).getException());
        }
        boolean noPrimaryErrors = errors.isEmpty();
        for (BrooklynClassLoadingContext target : this.secondaries) {
            Maybe clazz = target.tryLoadClass(className);
            if (clazz.isPresent()) {
                return clazz;
            }
            if (!noPrimaryErrors) continue;
            errors.add(((Maybe.Absent)clazz).getException());
        }
        return Maybe.absent((Throwable)Exceptions.create((String)("Unable to load " + className + " from " + this.primaries), (Collection)errors));
    }

    public URL getResource(String resourceInThatDir) {
        URL result;
        for (BrooklynClassLoadingContext target : this.primaries) {
            result = target.getResource(resourceInThatDir);
            if (result == null) continue;
            return result;
        }
        for (BrooklynClassLoadingContext target : this.secondaries) {
            result = target.getResource(resourceInThatDir);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public String toString() {
        return "classload:" + this.primaries + ";" + this.secondaries;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.primaries, this.secondaries});
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof BrooklynClassLoadingContextSequential)) {
            return false;
        }
        if (!Objects.equal(this.primaries, ((BrooklynClassLoadingContextSequential)obj).primaries)) {
            return false;
        }
        return Objects.equal(this.secondaries, ((BrooklynClassLoadingContextSequential)obj).secondaries);
    }
}

