/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.management.classloading;

import brooklyn.management.ManagementContext;
import brooklyn.management.classloading.BrooklynClassLoadingContext;
import brooklyn.util.guava.Maybe;
import com.google.common.base.Objects;
import javax.annotation.Nullable;

public abstract class AbstractBrooklynClassLoadingContext
implements BrooklynClassLoadingContext {
    protected final ManagementContext mgmt;

    public AbstractBrooklynClassLoadingContext(ManagementContext mgmt) {
        this.mgmt = mgmt;
    }

    public ManagementContext getManagementContext() {
        return this.mgmt;
    }

    public Class<?> loadClass(String className) {
        return (Class)this.tryLoadClass(className).get();
    }

    public abstract Maybe<Class<?>> tryLoadClass(String var1);

    public <T> Class<? extends T> loadClass(String className, @Nullable Class<T> supertype) {
        return (Class)this.tryLoadClass(className, supertype).get();
    }

    public <T> Maybe<Class<? extends T>> tryLoadClass(String className, @Nullable Class<T> supertype) {
        Maybe<Class<?>> result = this.tryLoadClass(className);
        if (result.isAbsent()) {
            return result;
        }
        Class clazz = (Class)result.get();
        if (supertype == null || supertype.isAssignableFrom(clazz)) {
            return result;
        }
        throw new ClassCastException(className + " is not an instance of " + supertype);
    }

    public abstract String toString();

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mgmt});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BrooklynClassLoadingContext)) {
            return false;
        }
        return Objects.equal((Object)this.mgmt, (Object)((BrooklynClassLoadingContext)obj).getManagementContext());
    }
}

