/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.geo;

import brooklyn.util.ResourceUtils;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.text.StringPredicates;
import brooklyn.util.time.Duration;
import brooklyn.util.time.Durations;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalhostExternalIpLoader {
    public static final Logger LOG = LoggerFactory.getLogger(LocalhostExternalIpLoader.class);
    private static final AtomicBoolean retrievingLocalExternalIp = new AtomicBoolean(false);
    private static final CountDownLatch triedLocalExternalIp = new CountDownLatch(1);
    private static volatile String localExternalIp;

    @VisibleForTesting
    static List<String> getIpAddressWebsites() {
        String file = new ResourceUtils(LocalhostExternalIpLoader.class).getResourceAsString("classpath://brooklyn/location/geo/external-ip-address-resolvers.txt");
        Iterable lines = Splitter.on((char)'\n').omitEmptyStrings().trimResults().split((CharSequence)file);
        ArrayList urls = Lists.newArrayList((Iterable)Iterables.filter((Iterable)lines, (Predicate)Predicates.not((Predicate)StringPredicates.startsWith((String)"#"))));
        Collections.shuffle(urls);
        return urls;
    }

    @VisibleForTesting
    static String getIpAddressFrom(String url) {
        return new IpLoader(url).call();
    }

    public static String getLocalhostIpQuicklyOrDefault() {
        String result = LocalhostExternalIpLoader.doLoad(Duration.seconds((Number)2));
        if (result == null) {
            return "127.0.0.1";
        }
        return result;
    }

    public static String getLocalhostIpWaiting() {
        return LocalhostExternalIpLoader.getLocalhostIpWithin(null);
    }

    public static String getLocalhostIpWithin(Duration timeout) {
        String result = LocalhostExternalIpLoader.doLoad(timeout);
        if (result == null) {
            throw new IllegalStateException("Unable to retrieve external IP for localhost; network may be down or slow or remote service otherwise not responding");
        }
        return result;
    }

    private static String doLoad(Duration blockFor) {
        if (localExternalIp != null) {
            return localExternalIp;
        }
        final List<String> candidateUrls = LocalhostExternalIpLoader.getIpAddressWebsites();
        if (candidateUrls.isEmpty()) {
            LOG.debug("No candidate URLs to use to determine external IP of localhost");
            return null;
        }
        if (retrievingLocalExternalIp.compareAndSet(false, true)) {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    for (String url : candidateUrls) {
                        try {
                            LOG.debug("Looking up external IP of this host from {} in private thread {}", (Object)url, (Object)Thread.currentThread());
                            localExternalIp = new IpLoader(url).call();
                            LOG.debug("Finished looking up external IP of this host from {} in private thread, result {}", (Object)url, (Object)localExternalIp);
                            break;
                        }
                        catch (Throwable t) {
                            LOG.debug("Unable to look up external IP of this host from {}, probably offline {})", (Object)url, (Object)t);
                        }
                        finally {
                            retrievingLocalExternalIp.set(false);
                            triedLocalExternalIp.countDown();
                        }
                    }
                }
            }.start();
        }
        try {
            if (blockFor != null) {
                Durations.await((CountDownLatch)triedLocalExternalIp, (Duration)blockFor);
            } else {
                triedLocalExternalIp.await();
            }
        }
        catch (InterruptedException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        if (localExternalIp == null) {
            return null;
        }
        return localExternalIp;
    }

    private static class IpLoader
    implements Callable<String> {
        private static final Pattern ipPattern = Pattern.compile("\\b((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])\\.){3}(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])\\b");
        final String url;

        protected IpLoader(String url) {
            this.url = url;
        }

        @Override
        public String call() {
            String response = ResourceUtils.create(LocalhostExternalIpLoader.class).getResourceAsString(this.url).trim();
            return this.postProcessResponse(response);
        }

        String postProcessResponse(String response) {
            Matcher matcher = ipPattern.matcher(response);
            boolean matched = matcher.find();
            if (!matched) {
                LOG.error("No IP address matched in output from {}: {}", (Object)this.url, (Object)response);
                return null;
            }
            return matcher.group();
        }
    }
}

