/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.dynamic;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.BasicAttributeSensorAndConfigKey;
import brooklyn.event.basic.Sensors;
import brooklyn.location.Location;
import brooklyn.location.LocationDefinition;
import brooklyn.location.dynamic.DynamicLocation;
import brooklyn.util.flags.SetFromFlag;
import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.util.Map;

@Beta
public interface LocationOwner<L extends Location & DynamicLocation<E, L>, E extends Entity & LocationOwner<L, E>> {
    @SetFromFlag(value="locationPrefix")
    public static final ConfigKey<String> LOCATION_NAME_PREFIX = ConfigKeys.newStringConfigKey("entity.dynamicLocation.prefix", "The name prefix for the location owned by this entity", "dynamic");
    @SetFromFlag(value="locationSuffix")
    public static final ConfigKey<String> LOCATION_NAME_SUFFIX = ConfigKeys.newStringConfigKey("entity.dynamicLocation.suffix", "The name suffix for the location owned by this entity");
    @SetFromFlag(value="locationName")
    public static final BasicAttributeSensorAndConfigKey<String> LOCATION_NAME = new BasicAttributeSensorAndConfigKey<String>(String.class, "entity.dynamicLocation.name", "The name of the location owned by this entity (default is auto-generated using prefix and suffix keys)");
    public static final ConfigKey<Map<String, Object>> LOCATION_FLAGS = ConfigKeys.newConfigKey(new TypeToken<Map<String, Object>>(){}, "entity.dynamicLocation.flags", "Extra creation flags for the Location owned by this entity", ImmutableMap.of());
    public static final AttributeSensor<Location> DYNAMIC_LOCATION = Sensors.newSensor(Location.class, "entity.dynamicLocation", "The location owned by this entity");
    public static final AttributeSensor<String> LOCATION_SPEC = Sensors.newStringSensor("entity.dynamicLocation.spec", "The specification string for the location owned by this entity");
    public static final AttributeSensor<Boolean> DYNAMIC_LOCATION_STATUS = Sensors.newBooleanSensor("entity.dynamicLocation.status", "The status of the location owned by this entity");
    public static final AttributeSensor<LocationDefinition> LOCATION_DEFINITION = Sensors.newSensor(LocationDefinition.class, "entity.dynamicLocation.definition", "The location definition for the location owned by this entity");

    public L getDynamicLocation();

    public L createLocation(Map<String, ?> var1);

    public boolean isLocationAvailable();

    public void deleteLocation();
}

