/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.cloud.names;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.location.cloud.CloudLocationConfig;
import brooklyn.location.cloud.names.BasicCloudMachineNamer;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.text.Strings;
import brooklyn.util.text.TemplateProcessor;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.util.Map;

public class CustomMachineNamer
extends BasicCloudMachineNamer {
    public static final ConfigKey<String> MACHINE_NAME_TEMPLATE = ConfigKeys.newStringConfigKey("custom.machine.namer.machine", "Freemarker template format for custom machine name", "${entity.displayName}");
    public static final ConfigKey<Map<String, ?>> EXTRA_SUBSTITUTIONS = ConfigKeys.newConfigKey(new TypeToken<Map<String, ?>>(){}, "custom.machine.namer.substitutions", "Additional substitutions to be used in the template", ImmutableMap.of());

    @Override
    protected String generateNewIdOfLength(ConfigBag setup, int len) {
        Object context = setup.peek(CloudLocationConfig.CALLER_CONTEXT);
        Entity entity = null;
        if (context instanceof Entity) {
            entity = (Entity)context;
        }
        String template = setup.get(MACHINE_NAME_TEMPLATE);
        String processed = entity == null ? TemplateProcessor.processTemplateContents(template, setup.get(EXTRA_SUBSTITUTIONS)) : TemplateProcessor.processTemplateContents(template, (EntityInternal)entity, setup.get(EXTRA_SUBSTITUTIONS));
        processed = Strings.removeFromStart((String)processed, (String)"#ftl\n");
        return CustomMachineNamer.sanitize(processed);
    }
}

