/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.cloud.names;

import brooklyn.entity.Application;
import brooklyn.entity.Entity;
import brooklyn.location.cloud.CloudLocationConfig;
import brooklyn.location.cloud.names.AbstractCloudMachineNamer;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.text.Identifiers;
import brooklyn.util.text.StringShortener;
import brooklyn.util.text.Strings;

public class BasicCloudMachineNamer
extends AbstractCloudMachineNamer {
    @Override
    protected String generateNewIdOfLength(ConfigBag setup, int len) {
        Object context = setup.peek(CloudLocationConfig.CALLER_CONTEXT);
        Entity entity = null;
        if (context instanceof Entity) {
            entity = (Entity)context;
        }
        StringShortener shortener = Strings.shortener().separator("-");
        shortener.append("system", "brooklyn");
        shortener.append("randId", Identifiers.makeRandomId((int)4));
        String user = System.getProperty("user.name");
        if (!"brooklyn".equals(user)) {
            shortener.append("user", user);
        }
        if (entity != null) {
            Application app = entity.getApplication();
            if (app != null) {
                shortener.append("app", BasicCloudMachineNamer.shortName(app)).append("appId", app.getId());
            }
            shortener.append("entity", BasicCloudMachineNamer.shortName(entity)).append("entityId", entity.getId());
        } else if (context != null) {
            shortener.append("context", context.toString());
        }
        shortener.truncate("user", 12).truncate("app", 16).truncate("entity", 16).truncate("appId", 4).truncate("entityId", 4).truncate("context", 12);
        shortener.canTruncate("user", 8).canTruncate("app", 5).canTruncate("entity", 5).canTruncate("system", 2).canTruncate("app", 3).canTruncate("entity", 3).canRemove("app").canTruncate("user", 4).canRemove("entity").canTruncate("context", 4).canTruncate("randId", 2).canRemove("user").canTruncate("appId", 2).canRemove("appId");
        String s = shortener.getStringOfMaxLength(len);
        return BasicCloudMachineNamer.sanitize(s).toLowerCase();
    }
}

