/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.cloud.names;

import brooklyn.entity.Entity;
import brooklyn.entity.trait.HasShortName;
import brooklyn.location.cloud.CloudLocationConfig;
import brooklyn.location.cloud.names.CloudMachineNamer;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.text.Identifiers;
import brooklyn.util.text.Strings;
import com.google.common.annotations.Beta;
import com.google.common.base.CharMatcher;

public abstract class AbstractCloudMachineNamer
implements CloudMachineNamer {
    int defaultMachineNameMaxLength = (Integer)CloudLocationConfig.VM_NAME_MAX_LENGTH.getDefaultValue();
    int defaultMachineNameSaltLength = (Integer)CloudLocationConfig.VM_NAME_SALT_LENGTH.getDefaultValue();
    protected String separator = "-";

    @Override
    public String generateNewMachineUniqueName(ConfigBag setup) {
        return this.generateNewIdReservingLength(setup, 0);
    }

    @Override
    public String generateNewMachineUniqueNameFromGroupId(ConfigBag setup, String groupId) {
        int availSaltLength = this.getMaxNameLength(setup) - (groupId.length() + this.separator.length());
        int requestedSaltLength = this.getLengthForMachineUniqueNameSalt(setup, false);
        if (availSaltLength <= 0 || requestedSaltLength <= 0) {
            return groupId;
        }
        return AbstractCloudMachineNamer.sanitize(groupId + this.separator + Identifiers.makeRandomId((int)Math.min(requestedSaltLength, availSaltLength))).toLowerCase();
    }

    @Override
    public String generateNewGroupId(ConfigBag setup) {
        return AbstractCloudMachineNamer.sanitize(this.generateNewIdReservingLength(setup, this.getLengthForMachineUniqueNameSalt(setup, true))).toLowerCase();
    }

    protected String generateNewIdReservingLength(ConfigBag setup, int lengthToReserve) {
        int len = this.getMaxNameLength(setup);
        if ((len -= lengthToReserve) <= 0) {
            return "";
        }
        return Strings.maxlen((String)this.generateNewIdOfLength(setup, len), (int)len);
    }

    protected abstract String generateNewIdOfLength(ConfigBag var1, int var2);

    public int getMaxNameLength(ConfigBag setup) {
        if (setup.containsKey(CloudLocationConfig.VM_NAME_MAX_LENGTH)) {
            return setup.get(CloudLocationConfig.VM_NAME_MAX_LENGTH);
        }
        Integer custom = this.getCustomMaxNameLength(setup);
        if (custom != null) {
            return custom;
        }
        return this.defaultMachineNameMaxLength;
    }

    public int getLengthForMachineUniqueNameSalt(ConfigBag setup, boolean includeSeparator) {
        int saltLen = setup.containsKey(CloudLocationConfig.VM_NAME_SALT_LENGTH) ? setup.get(CloudLocationConfig.VM_NAME_SALT_LENGTH) : this.defaultMachineNameSaltLength;
        if (saltLen > 0 && includeSeparator) {
            saltLen += this.separator.length();
        }
        return saltLen;
    }

    public AbstractCloudMachineNamer setDefaultMachineNameMaxLength(int defaultMaxLength) {
        this.defaultMachineNameMaxLength = defaultMaxLength;
        return this;
    }

    public AbstractCloudMachineNamer setDefaultMachineNameSeparatorAndSaltLength(String separator, int defaultMachineUniqueNameSaltLength) {
        this.separator = separator;
        this.defaultMachineNameSaltLength = defaultMachineUniqueNameSaltLength;
        return this;
    }

    public Integer getCustomMaxNameLength(ConfigBag setup) {
        return null;
    }

    protected static String shortName(Object x) {
        if (x instanceof HasShortName) {
            return ((HasShortName)x).getShortName();
        }
        if (x instanceof Entity) {
            return ((Entity)x).getDisplayName();
        }
        return x.toString();
    }

    @Beta
    public static String sanitize(String s) {
        return CharMatcher.inRange((char)'A', (char)'Z').or(CharMatcher.inRange((char)'a', (char)'z')).or(CharMatcher.inRange((char)'0', (char)'9')).negate().trimAndCollapseFrom((CharSequence)s, '-');
    }
}

