/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.cloud;

import brooklyn.location.Location;
import brooklyn.location.LocationSpec;
import brooklyn.location.MachineLocation;
import brooklyn.location.MachineProvisioningLocation;
import brooklyn.location.basic.AbstractLocation;
import brooklyn.location.cloud.CloudLocationConfig;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.internal.ssh.SshTool;
import java.util.Collection;
import java.util.Map;

public abstract class AbstractCloudMachineProvisioningLocation
extends AbstractLocation
implements MachineProvisioningLocation<MachineLocation>,
CloudLocationConfig {
    public AbstractCloudMachineProvisioningLocation() {
    }

    public AbstractCloudMachineProvisioningLocation(Map<?, ?> conf) {
        super(conf);
    }

    public AbstractCloudMachineProvisioningLocation newSubLocation(Map<?, ?> newFlags) {
        return this.newSubLocation(this.getClass(), newFlags);
    }

    public AbstractCloudMachineProvisioningLocation newSubLocation(Class<? extends AbstractCloudMachineProvisioningLocation> type, Map<?, ?> newFlags) {
        return (AbstractCloudMachineProvisioningLocation)this.getManagementContext().getLocationManager().createLocation(LocationSpec.create(type).parent((Location)this).configure(this.config().getLocalBag().getAllConfig()).configure(newFlags));
    }

    public Map<String, Object> getProvisioningFlags(Collection<String> tags) {
        if (tags.size() > 0) {
            LOG.warn("Location {}, ignoring provisioning tags {}", (Object)this, tags);
        }
        return MutableMap.of();
    }

    protected ConfigBag extractSshConfig(ConfigBag setup, ConfigBag alt) {
        ConfigBag sshConfig = new ConfigBag();
        if (setup.containsKey(PASSWORD)) {
            sshConfig.put(SshTool.PROP_PASSWORD, setup.get(PASSWORD));
        } else if (alt.containsKey(PASSWORD)) {
            sshConfig.put(SshTool.PROP_PASSWORD, alt.get(PASSWORD));
        }
        if (setup.containsKey(PRIVATE_KEY_DATA)) {
            sshConfig.put(SshTool.PROP_PRIVATE_KEY_DATA, setup.get(PRIVATE_KEY_DATA));
        } else if (setup.containsKey(PRIVATE_KEY_FILE)) {
            sshConfig.put(SshTool.PROP_PRIVATE_KEY_FILE, setup.get(PRIVATE_KEY_FILE));
        } else if (alt.containsKey(PRIVATE_KEY_DATA)) {
            sshConfig.put(SshTool.PROP_PRIVATE_KEY_DATA, alt.get(PRIVATE_KEY_DATA));
        }
        if (setup.containsKey(PRIVATE_KEY_PASSPHRASE)) {
            sshConfig.put(SshTool.PROP_PRIVATE_KEY_PASSPHRASE, setup.get(PRIVATE_KEY_PASSPHRASE));
        }
        return sshConfig;
    }
}

