/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.basic;

import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.location.MachineDetails;
import brooklyn.location.MachineLocation;
import brooklyn.location.OsDetails;
import brooklyn.location.basic.AbstractLocation;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.stream.Streams;
import brooklyn.util.time.Duration;
import brooklyn.util.time.Time;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import io.cloudsoft.winrm4j.winrm.WinRmTool;
import io.cloudsoft.winrm4j.winrm.WinRmToolResponse;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WinRmMachineLocation
extends AbstractLocation
implements MachineLocation {
    private static final Logger LOG = LoggerFactory.getLogger(WinRmMachineLocation.class);
    public static final ConfigKey<Integer> WINRM_PORT = ConfigKeys.newIntegerConfigKey("port", "WinRM port to use when connecting to the remote machine", 5985);
    public static final ConfigKey<String> USER = ConfigKeys.newStringConfigKey("user", "Username to use when connecting to the remote machine");
    public static final ConfigKey<String> PASSWORD = ConfigKeys.newStringConfigKey("password", "Password to use when connecting to the remote machine");
    public static final ConfigKey<Integer> COPY_FILE_CHUNK_SIZE_BYTES = ConfigKeys.newIntegerConfigKey("windows.copy.file.size.bytes", "Size of file chunks (in bytes) to be used when copying a file to the remote server", 1024);
    public static final ConfigKey<InetAddress> ADDRESS = ConfigKeys.newConfigKey(InetAddress.class, "address", "Address of the remote machine");
    public static final ConfigKey<Integer> EXECUTION_ATTEMPTS = ConfigKeys.newIntegerConfigKey("windows.exec.attempts", "Number of attempts to execute a remote command", 1);
    public static final ConfigKey<Integer> EXEC_TRIES = ConfigKeys.newIntegerConfigKey("execTries", "Max number of times to attempt WinRM operations", 10);

    public InetAddress getAddress() {
        return this.getConfig(ADDRESS);
    }

    public OsDetails getOsDetails() {
        return null;
    }

    public MachineDetails getMachineDetails() {
        return null;
    }

    @Nullable
    public String getHostname() {
        InetAddress address = this.getAddress();
        return address != null ? address.getHostAddress() : null;
    }

    @Nullable
    protected String getHostAndPort() {
        String host = this.getHostname();
        return host == null ? null : host + ":" + this.config().get(WINRM_PORT);
    }

    public Set<String> getPublicAddresses() {
        InetAddress address = this.getAddress();
        return address == null ? ImmutableSet.of() : ImmutableSet.of((Object)address.getHostAddress());
    }

    public Set<String> getPrivateAddresses() {
        return ImmutableSet.of();
    }

    public WinRmToolResponse executeScript(String script) {
        return this.executeScript((List<String>)ImmutableList.of((Object)script));
    }

    public WinRmToolResponse executeScript(List<String> script) {
        int execTries = this.getRequiredConfig(EXEC_TRIES);
        ArrayList exceptions = Lists.newArrayList();
        for (int i = 0; i < execTries; ++i) {
            try {
                return this.executeScriptNoRetry(script);
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                if (i == execTries + 1) {
                    LOG.info("Propagating WinRM exception (attempt " + (i + 1) + " of " + execTries + ")", (Throwable)e);
                } else if (i == 0) {
                    LOG.warn("Ignoring WinRM exception and retrying (attempt " + (i + 1) + " of " + execTries + ")", (Throwable)e);
                } else {
                    LOG.debug("Ignoring WinRM exception and retrying (attempt " + (i + 1) + " of " + execTries + ")", (Throwable)e);
                }
                exceptions.add(e);
                continue;
            }
        }
        throw Exceptions.propagate((String)"failed to execute shell script", (Collection)exceptions);
    }

    protected WinRmToolResponse executeScriptNoRetry(List<String> script) {
        WinRmTool winRmTool = WinRmTool.connect((String)this.getHostAndPort(), (String)this.getUser(), (String)this.getPassword());
        WinRmToolResponse response = winRmTool.executeScript(script);
        return response;
    }

    public WinRmToolResponse executePsScript(String psScript) {
        return this.executePsScript((List<String>)ImmutableList.of((Object)psScript));
    }

    public WinRmToolResponse executePsScript(List<String> psScript) {
        int execTries = this.getRequiredConfig(EXEC_TRIES);
        ArrayList exceptions = Lists.newArrayList();
        for (int i = 0; i < execTries; ++i) {
            try {
                return this.executePsScriptNoRetry(psScript);
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                if (i == execTries + 1) {
                    LOG.info("Propagating WinRM exception (attempt " + (i + 1) + " of " + execTries + ")", (Throwable)e);
                } else if (i == 0) {
                    LOG.warn("Ignoring WinRM exception and retrying after 5 seconds (attempt " + (i + 1) + " of " + execTries + ")", (Throwable)e);
                    Time.sleep((Duration)Duration.FIVE_SECONDS);
                } else {
                    LOG.debug("Ignoring WinRM exception and retrying after 5 seconds (attempt " + (i + 1) + " of " + execTries + ")", (Throwable)e);
                    Time.sleep((Duration)Duration.FIVE_SECONDS);
                }
                exceptions.add(e);
                continue;
            }
        }
        throw Exceptions.propagate((String)"failed to execute powershell script", (Collection)exceptions);
    }

    public WinRmToolResponse executePsScriptNoRetry(List<String> psScript) {
        WinRmTool winRmTool = WinRmTool.connect((String)this.getHostAndPort(), (String)this.getUser(), (String)this.getPassword());
        WinRmToolResponse response = winRmTool.executePs(psScript);
        return response;
    }

    public int copyTo(File source, String destination) {
        FileInputStream sourceStream = null;
        try {
            sourceStream = new FileInputStream(source);
            int n = this.copyTo(sourceStream, destination);
            return n;
        }
        catch (FileNotFoundException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        finally {
            if (sourceStream != null) {
                Streams.closeQuietly((Closeable)sourceStream);
            }
        }
    }

    public int copyTo(InputStream source, String destination) {
        this.executePsScript((List<String>)ImmutableList.of((Object)("rm -ErrorAction SilentlyContinue " + destination)));
        try {
            int bytesRead;
            int chunkSize = this.getConfig(COPY_FILE_CHUNK_SIZE_BYTES);
            byte[] inputData = new byte[chunkSize];
            int expectedFileSize = 0;
            while ((bytesRead = source.read(inputData)) > 0) {
                byte[] chunk = bytesRead == chunkSize ? inputData : Arrays.copyOf(inputData, bytesRead);
                this.executePsScript((List<String>)ImmutableList.of((Object)("If ((!(Test-Path " + destination + ")) -or ((Get-Item '" + destination + "').length -eq " + expectedFileSize + ")) {Add-Content -Encoding Byte -path " + destination + " -value ([System.Convert]::FromBase64String(\"" + new String(Base64.encodeBase64((byte[])chunk)) + "\"))}")));
                expectedFileSize += bytesRead;
            }
            return 0;
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    @Override
    public void init() {
        super.init();
    }

    public String getUser() {
        return (String)this.config().get(USER);
    }

    private String getPassword() {
        return (String)this.config().get(PASSWORD);
    }

    private <T> T getRequiredConfig(ConfigKey<T> key) {
        return (T)Preconditions.checkNotNull(this.getConfig(key), (String)"key %s must be set", (Object[])new Object[]{key});
    }

    public static String getDefaultUserMetadataString() {
        String unencodePowershell = Joiner.on((String)"\r\n").join((Iterable)ImmutableList.of((Object)"$RDP = Get-WmiObject -Class Win32_TerminalServiceSetting -ComputerName $env:computername -Namespace root\\CIMV2\\TerminalServices -Authentication PacketPrivacy", (Object)"$RDP.SetAllowTSConnections(1,1)", (Object)"Set-ExecutionPolicy Unrestricted -Force", (Object)"Set-Item WSMan:\\localhost\\Shell\\MaxConcurrentUsers 100", (Object)"Set-Item WSMan:\\localhost\\Shell\\MaxMemoryPerShellMB 0", (Object)"Set-Item WSMan:\\localhost\\Shell\\MaxProcessesPerShell 0", (Object)"Set-Item WSMan:\\localhost\\Shell\\MaxShellsPerUser 0", (Object)"New-ItemProperty \"HKLM:\\System\\CurrentControlSet\\Control\\LSA\" -Name \"SuppressExtendedProtection\" -Value 1 -PropertyType \"DWord\"", (Object)"$allowed = @('WSMAN/*')", (Object)"$key = 'hklm:\\SOFTWARE\\Policies\\Microsoft\\Windows\\CredentialsDelegation'", (Object)"if (!(Test-Path $key)) {", (Object)"    md $key", (Object[])new String[]{"}", "New-ItemProperty -Path $key -Name AllowFreshCredentials -Value 1 -PropertyType Dword -Force", "New-ItemProperty -Path $key -Name AllowFreshCredentialsWhenNTLMOnly -Value 1 -PropertyType Dword -Force", "$credKey = Join-Path $key 'AllowFreshCredentials'", "if (!(Test-Path $credKey)) {", "    md $credkey", "}", "$ntlmKey = Join-Path $key 'AllowFreshCredentialsWhenNTLMOnly'", "if (!(Test-Path $ntlmKey)) {", "    md $ntlmKey", "}", "$i = 1", "$allowed |% {", "    # Script does not take into account existing entries in this key", "    New-ItemProperty -Path $credKey -Name $i -Value $_ -PropertyType String -Force", "    New-ItemProperty -Path $ntlmKey -Name $i -Value $_ -PropertyType String -Force", "    $i++", "}"}));
        String encoded = new String(Base64.encodeBase64((byte[])unencodePowershell.getBytes(Charsets.UTF_16LE)));
        return "winrm quickconfig -q & winrm set winrm/config/service/auth @{Basic=\"true\"} & winrm set winrm/config/service/auth @{CredSSP=\"true\"} & winrm set winrm/config/client/auth @{CredSSP=\"true\"} & winrm set winrm/config/client @{AllowUnencrypted=\"true\"} & winrm set winrm/config/service @{AllowUnencrypted=\"true\"} & winrm set winrm/config/winrs @{MaxConcurrentUsers=\"100\"} & winrm set winrm/config/winrs @{MaxMemoryPerShellMB=\"0\"} & winrm set winrm/config/winrs @{MaxProcessesPerShell=\"0\"} & winrm set winrm/config/winrs @{MaxShellsPerUser=\"0\"} & netsh advfirewall firewall add rule name=RDP dir=in protocol=tcp localport=3389 action=allow profile=any & netsh advfirewall firewall add rule name=WinRM dir=in protocol=tcp localport=5985 action=allow profile=any & powershell -EncodedCommand " + encoded;
    }
}

