/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.basic;

import brooklyn.location.MachineLocation;
import brooklyn.location.MachineProvisioningLocation;
import brooklyn.location.NoMachinesAvailableException;
import brooklyn.location.basic.FixedListMachineProvisioningLocation;
import brooklyn.util.flags.SetFromFlag;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleMachineProvisioningLocation<T extends MachineLocation>
extends FixedListMachineProvisioningLocation<T> {
    private static final long serialVersionUID = -4216528515792151062L;
    private static final Logger log = LoggerFactory.getLogger(SingleMachineProvisioningLocation.class);
    @SetFromFlag(nullable=false)
    private String location;
    @SetFromFlag(nullable=false)
    private Map<?, ?> locationFlags;
    private T singleLocation;
    private int referenceCount;
    private MachineProvisioningLocation<T> provisioningLocation;

    public SingleMachineProvisioningLocation() {
    }

    public SingleMachineProvisioningLocation(String location, Map locationFlags) {
        this.locationFlags = locationFlags;
        this.location = location;
    }

    @Override
    public synchronized T obtain(Map flags) throws NoMachinesAvailableException {
        log.info("Flags {} passed to newLocationFromString will be ignored, using {}", (Object)flags, this.locationFlags);
        return this.obtain();
    }

    @Override
    public synchronized T obtain() throws NoMachinesAvailableException {
        if (this.singleLocation == null) {
            if (this.provisioningLocation == null) {
                this.provisioningLocation = (MachineProvisioningLocation)this.getManagementContext().getLocationRegistry().resolve(this.location, this.locationFlags);
            }
            this.singleLocation = this.provisioningLocation.obtain((Map)ImmutableMap.of());
            this.inUse.add(this.singleLocation);
        }
        ++this.referenceCount;
        return this.singleLocation;
    }

    @Override
    public synchronized void release(T machine) {
        if (!machine.equals(this.singleLocation)) {
            throw new IllegalArgumentException("Invalid machine " + machine + " passed to release, expecting: " + this.singleLocation);
        }
        if (--this.referenceCount == 0) {
            this.provisioningLocation.release(machine);
            this.singleLocation = null;
        }
        this.inUse.remove(machine);
    }
}

