/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.basic;

import brooklyn.location.Location;
import brooklyn.location.LocationRegistry;
import brooklyn.location.LocationSpec;
import brooklyn.location.basic.AbstractLocationResolver;
import brooklyn.location.basic.LocationConfigUtils;
import brooklyn.location.basic.LocationInternal;
import brooklyn.location.basic.LocationPropertiesFromBrooklynProperties;
import brooklyn.location.basic.SingleMachineProvisioningLocation;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.guava.Maybe;
import java.util.Map;

public class SingleMachineLocationResolver
extends AbstractLocationResolver {
    private static final String SINGLE = "single";

    @Override
    public Location newLocationFromString(Map locationFlags, String spec, LocationRegistry registry) {
        ConfigBag config = this.extractConfig(locationFlags, spec, registry);
        Map globalProperties = registry.getProperties();
        String namedLocation = (String)locationFlags.get(LocationInternal.NAMED_SPEC_NAME.getName());
        if (registry != null) {
            LocationPropertiesFromBrooklynProperties.setLocalTempDir(globalProperties, config);
        }
        if (config.getStringKey("target") == null) {
            throw new IllegalArgumentException("target must be specified in single-machine spec");
        }
        String target = config.getStringKey("target").toString();
        config.remove("target");
        Maybe testResolve = this.managementContext.getLocationRegistry().resolve(target, Boolean.valueOf(false), null);
        if (!testResolve.isPresent()) {
            throw new IllegalArgumentException("Invalid target location '" + target + "' for location '" + SINGLE + "': " + Exceptions.collapseText((Throwable)((Maybe.Absent)testResolve).getException()));
        }
        return this.managementContext.getLocationManager().createLocation(LocationSpec.create(SingleMachineProvisioningLocation.class).configure((CharSequence)"location", (Object)target).configure((CharSequence)"locationFlags", config.getAllConfig()).configure(LocationConfigUtils.finalAndOriginalSpecs(spec, locationFlags, globalProperties, namedLocation)));
    }

    public String getPrefix() {
        return SINGLE;
    }

    @Override
    protected Class<? extends Location> getLocationType() {
        return SingleMachineProvisioningLocation.class;
    }

    @Override
    protected AbstractLocationResolver.SpecParser getSpecParser() {
        return new AbstractLocationResolver.SpecParser(this.getPrefix()).setExampleUsage("\"single(target=jclouds:aws-ec2:us-east-1)\"");
    }
}

