/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.basic;

import brooklyn.location.Location;
import brooklyn.location.LocationSpec;
import brooklyn.location.MachineDetails;
import brooklyn.location.MachineLocation;
import brooklyn.location.MachineProvisioningLocation;
import brooklyn.location.OsDetails;
import brooklyn.location.PortRange;
import brooklyn.location.PortSupplier;
import brooklyn.location.basic.AbstractLocation;
import brooklyn.location.basic.BasicHardwareDetails;
import brooklyn.location.basic.BasicMachineDetails;
import brooklyn.location.basic.BasicOsDetails;
import brooklyn.location.basic.PortRanges;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.net.Networking;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SimulatedLocation
extends AbstractLocation
implements MachineProvisioningLocation<MachineLocation>,
MachineLocation,
PortSupplier {
    private static final long serialVersionUID = 1L;
    private static final InetAddress address = Networking.getLocalHost();
    Iterable<Integer> permittedPorts = PortRanges.fromString("1+");
    Set<Integer> usedPorts = Sets.newLinkedHashSet();

    public SimulatedLocation() {
        this((Map<String, ? extends Object>)MutableMap.of());
    }

    public SimulatedLocation(Map<String, ? extends Object> flags) {
        super(flags);
    }

    public SimulatedLocation newSubLocation(Map<?, ?> newFlags) {
        return (SimulatedLocation)this.getManagementContext().getLocationManager().createLocation(LocationSpec.create(this.getClass()).parent((Location)this).configure(this.config().getLocalBag().getAllConfig()).configure(newFlags));
    }

    public MachineLocation obtain(Map<?, ?> flags) {
        return this;
    }

    public void release(MachineLocation machine) {
    }

    public Map<String, Object> getProvisioningFlags(Collection<String> tags) {
        return MutableMap.of();
    }

    public InetAddress getAddress() {
        return address;
    }

    public String getHostname() {
        String hostname = address.getHostName();
        return hostname == null || hostname.equals(address.getHostAddress()) ? null : hostname;
    }

    public Set<String> getPublicAddresses() {
        return ImmutableSet.of((Object)address.getHostAddress());
    }

    public Set<String> getPrivateAddresses() {
        return ImmutableSet.of();
    }

    public synchronized boolean obtainSpecificPort(int portNumber) {
        if (!Iterables.contains(this.permittedPorts, (Object)portNumber)) {
            return false;
        }
        if (this.usedPorts.contains(portNumber)) {
            return false;
        }
        this.usedPorts.add(portNumber);
        return true;
    }

    public synchronized int obtainPort(PortRange range) {
        Iterator i$ = range.iterator();
        while (i$.hasNext()) {
            int p = (Integer)i$.next();
            if (!this.obtainSpecificPort(p)) continue;
            return p;
        }
        return -1;
    }

    public synchronized void releasePort(int portNumber) {
        this.usedPorts.remove(portNumber);
    }

    public synchronized void setPermittedPorts(Iterable<Integer> ports) {
        this.permittedPorts = ports;
    }

    public OsDetails getOsDetails() {
        return this.getMachineDetails().getOsDetails();
    }

    public MachineDetails getMachineDetails() {
        BasicHardwareDetails hardwareDetails = new BasicHardwareDetails(null, null);
        OsDetails osDetails = BasicOsDetails.Factory.ANONYMOUS_LINUX;
        return new BasicMachineDetails(hardwareDetails, osDetails);
    }
}

