/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.basic;

import brooklyn.location.Location;
import brooklyn.location.LocationDefinition;
import brooklyn.location.LocationRegistry;
import brooklyn.location.LocationResolver;
import brooklyn.location.basic.BasicLocationRegistry;
import brooklyn.location.basic.LocationInternal;
import brooklyn.management.ManagementContext;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.text.Strings;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedLocationResolver
implements LocationResolver {
    public static final Logger log = LoggerFactory.getLogger(NamedLocationResolver.class);
    public static final String NAMED = "named";
    private ManagementContext managementContext;

    public void init(ManagementContext managementContext) {
        this.managementContext = (ManagementContext)Preconditions.checkNotNull((Object)managementContext, (Object)"managementContext");
    }

    public Location newLocationFromString(Map locationFlags, String spec, LocationRegistry registry) {
        LocationDefinition ld;
        String name = spec;
        ConfigBag lfBag = ConfigBag.newInstance(locationFlags).putIfAbsent(LocationInternal.ORIGINAL_SPEC, name);
        name = Strings.removeFromStart((String)spec, (String)(this.getPrefix() + ":"));
        if (name.toLowerCase().startsWith("named:")) {
            log.warn("Deprecated use of 'named:' prefix with wrong case (" + spec + "); support may be removed in future versions");
            name = spec.substring("named:".length());
        }
        if ((ld = registry.getDefinedLocationByName(name)) == null) {
            throw new NoSuchElementException("No named location defined matching '" + name + "'");
        }
        return ((BasicLocationRegistry)registry).resolveLocationDefinition(ld, lfBag.getAllConfig(), name);
    }

    public String getPrefix() {
        return NAMED;
    }

    public boolean accepts(String spec, LocationRegistry registry) {
        if (BasicLocationRegistry.isResolverPrefixForSpec(this, spec, false)) {
            return true;
        }
        return registry.getDefinedLocationByName(spec) != null;
    }
}

