/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.basic;

import brooklyn.location.Location;
import brooklyn.location.LocationRegistry;
import brooklyn.location.LocationResolver;
import brooklyn.location.LocationSpec;
import brooklyn.location.basic.BasicLocationRegistry;
import brooklyn.location.basic.LocationConfigUtils;
import brooklyn.location.basic.LocationPropertiesFromBrooklynProperties;
import brooklyn.location.basic.Locations;
import brooklyn.location.basic.MultiLocation;
import brooklyn.management.ManagementContext;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.text.KeyValueParser;
import brooklyn.util.text.StringEscapes;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiLocationResolver
implements LocationResolver {
    private static final Logger LOG = LoggerFactory.getLogger(MultiLocationResolver.class);
    private static final String MULTI = "multi";
    private static final Pattern PATTERN = Pattern.compile("(multi|" + "multi".toUpperCase() + ")" + ":" + "\\((.*)\\)$");
    private volatile ManagementContext managementContext;

    public void init(ManagementContext managementContext) {
        this.managementContext = (ManagementContext)Preconditions.checkNotNull((Object)managementContext, (Object)"managementContext");
    }

    public Location newLocationFromString(Map locationFlags, String spec, LocationRegistry registry) {
        Object locationArgs;
        Map globalProperties = registry.getProperties();
        if (spec.equalsIgnoreCase(MULTI)) {
            locationArgs = MutableMap.copyOf((Map)locationFlags);
        } else {
            Matcher matcher = PATTERN.matcher(spec);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Invalid location '" + spec + "'; must specify something like multi(targets=named:foo)");
            }
            String args = matcher.group(2);
            locationArgs = KeyValueParser.parseMap((String)args);
        }
        String namedLocation = (String)locationFlags.get("named");
        Map<String, Object> filteredProperties = new LocationPropertiesFromBrooklynProperties().getLocationProperties(null, namedLocation, globalProperties);
        MutableMap flags = MutableMap.builder().putAll(filteredProperties).putAll(locationFlags).removeAll((Object[])new String[]{"named"}).putAll((Map)locationArgs).build();
        if (locationArgs.get("targets") == null) {
            throw new IllegalArgumentException("target must be specified in single-machine spec");
        }
        ArrayList targets = Lists.newArrayList();
        Object targetSpecs = locationArgs.remove("targets");
        try {
            if (targetSpecs instanceof String) {
                for (Object targetSpec : StringEscapes.JavaStringEscapes.unwrapJsonishListIfPossible((String)((String)targetSpecs))) {
                    targets.add(this.managementContext.getLocationRegistry().resolve((String)targetSpec));
                }
            } else if (targetSpecs instanceof Iterable) {
                for (Object targetSpec : (Iterable)targetSpecs) {
                    if (targetSpec instanceof String) {
                        targets.add(this.managementContext.getLocationRegistry().resolve((String)targetSpec));
                        continue;
                    }
                    Set keys = ((Map)targetSpec).keySet();
                    if (keys.size() != 1) {
                        throw new IllegalArgumentException("targets supplied to MultiLocation must be a list of single-entry maps (got map of size " + keys.size() + ": " + targetSpec + ")");
                    }
                    Object key = keys.iterator().next();
                    Object flagsS = ((Map)targetSpec).get(key);
                    targets.add(this.managementContext.getLocationRegistry().resolve((String)key, (Map)flagsS));
                }
            } else {
                throw new IllegalArgumentException("targets must be supplied to MultiLocation, either as string spec or list of single-entry maps each being a location spec");
            }
            MultiLocation result = (MultiLocation)this.managementContext.getLocationManager().createLocation(LocationSpec.create(MultiLocation.class).configure((Map)flags).configure((CharSequence)"subLocations", (Object)targets).configure(LocationConfigUtils.finalAndOriginalSpecs(spec, locationFlags, globalProperties, namedLocation)));
            for (Location target : targets) {
                target.setParent((Location)result);
            }
            return result;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Problem resolving MultiLocation; cleaning up any sub-locations and rethrowing: " + e);
            }
            for (Location target : targets) {
                Locations.unmanage(target);
            }
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public String getPrefix() {
        return MULTI;
    }

    public boolean accepts(String spec, LocationRegistry registry) {
        return BasicLocationRegistry.isResolverPrefixForSpec(this, spec, true);
    }
}

