/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.basic;

import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.location.Location;
import brooklyn.location.LocationSpec;
import brooklyn.location.MachineLocation;
import brooklyn.location.MachineProvisioningLocation;
import brooklyn.location.NoMachinesAvailableException;
import brooklyn.location.basic.AbstractLocation;
import brooklyn.location.cloud.AbstractAvailabilityZoneExtension;
import brooklyn.location.cloud.AvailabilityZoneExtension;
import brooklyn.management.ManagementContext;
import brooklyn.util.collections.MutableList;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.exceptions.CompoundRuntimeException;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.text.Strings;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MultiLocation<T extends MachineLocation>
extends AbstractLocation
implements MachineProvisioningLocation<T> {
    private static final long serialVersionUID = 7993091317970457862L;
    @SetFromFlag(value="subLocations")
    public static final ConfigKey<List<MachineProvisioningLocation<?>>> SUB_LOCATIONS = ConfigKeys.newConfigKey(new TypeToken<List<MachineProvisioningLocation<?>>>(){}, "subLocations", "The sub-machines that this location can delegate to");

    @Override
    public void init() {
        super.init();
        List<MachineProvisioningLocation<?>> subLocs = this.getSubLocations();
        Preconditions.checkState((subLocs.size() >= 1 ? 1 : 0) != 0, (Object)"sub-locations must not be empty");
        AvailabilityZoneExtensionImpl azExtension = new AvailabilityZoneExtensionImpl(this.getManagementContext(), subLocs);
        this.addExtension(AvailabilityZoneExtension.class, azExtension);
    }

    public T obtain() throws NoMachinesAvailableException {
        return this.obtain((Map<?, ?>)MutableMap.of());
    }

    public T obtain(Map<?, ?> flags) throws NoMachinesAvailableException {
        String msg;
        Exception wrapped;
        List<MachineProvisioningLocation<?>> sublocsList = this.getSubLocations();
        Iterator<MachineProvisioningLocation<?>> sublocs = sublocsList.iterator();
        MutableList errors = MutableList.of();
        while (sublocs.hasNext()) {
            try {
                return (T)sublocs.next().obtain(flags);
            }
            catch (NoMachinesAvailableException e) {
                errors.add(e);
            }
        }
        if (errors.size() > 1) {
            wrapped = new CompoundRuntimeException(errors.size() + " sublocation exceptions, including: " + Exceptions.collapseText((Throwable)((Throwable)errors.get(0))), (Iterable)errors);
            msg = Exceptions.collapseText((Throwable)wrapped);
        } else if (errors.size() == 1) {
            wrapped = (Exception)errors.get(0);
            msg = wrapped.getMessage();
            if (Strings.isBlank((CharSequence)msg)) {
                msg = wrapped.toString();
            }
        } else {
            msg = "no sub-locations set for this multi-location";
            wrapped = null;
        }
        throw new NoMachinesAvailableException("No machines available in any of the " + sublocsList.size() + " location" + Strings.s((int)sublocsList.size()) + " configured here: " + msg, (Throwable)wrapped);
    }

    public List<MachineProvisioningLocation<?>> getSubLocations() {
        return this.getRequiredConfig(SUB_LOCATIONS);
    }

    public MachineProvisioningLocation<T> newSubLocation(Map<?, ?> newFlags) {
        return (MachineProvisioningLocation)this.getManagementContext().getLocationManager().createLocation(LocationSpec.create(this.getClass()).parent((Location)this).configure(this.config().getLocalBag().getAllConfig()).configure(newFlags));
    }

    public void release(T machine) {
        ((MachineProvisioningLocation)machine.getParent()).release(machine);
    }

    public Map<String, Object> getProvisioningFlags(Collection<String> tags) {
        return Maps.newLinkedHashMap();
    }

    protected MachineProvisioningLocation<T> firstSubLoc() {
        return (MachineProvisioningLocation)Iterables.get(this.getSubLocations(), (int)0);
    }

    protected <K> K getRequiredConfig(ConfigKey<K> key) {
        return (K)Preconditions.checkNotNull(this.getConfig(key), (Object)key.getName());
    }

    public static class AvailabilityZoneExtensionImpl
    extends AbstractAvailabilityZoneExtension
    implements AvailabilityZoneExtension {
        private final List<MachineProvisioningLocation<?>> subLocations;

        public AvailabilityZoneExtensionImpl(ManagementContext managementContext, List<MachineProvisioningLocation<?>> subLocations) {
            super(managementContext);
            this.subLocations = ImmutableList.copyOf(subLocations);
        }

        @Override
        protected List<Location> doGetAllSubLocations() {
            return ImmutableList.copyOf(this.subLocations);
        }

        @Override
        protected boolean isNameMatch(Location loc, Predicate<? super String> namePredicate) {
            return namePredicate.apply((Object)loc.getDisplayName());
        }
    }
}

