/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.basic;

import brooklyn.config.ConfigKey;
import brooklyn.location.Location;
import brooklyn.location.basic.Locations;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import javax.annotation.Nullable;

public class LocationPredicates {
    public static <T> Predicate<Location> idEqualTo(final T val) {
        return new Predicate<Location>(){

            public boolean apply(@Nullable Location input) {
                return input != null && Objects.equal((Object)input.getId(), (Object)val);
            }
        };
    }

    public static <T> Predicate<Location> displayNameEqualTo(final T val) {
        return new Predicate<Location>(){

            public boolean apply(@Nullable Location input) {
                return input != null && Objects.equal((Object)input.getDisplayName(), (Object)val);
            }
        };
    }

    public static <T> Predicate<Location> configEqualTo(final ConfigKey<T> configKey, final T val) {
        return new Predicate<Location>(){

            public boolean apply(@Nullable Location input) {
                return input != null && Objects.equal((Object)input.getConfig(configKey), (Object)val);
            }
        };
    }

    public static <T> Predicate<Location> configEqualTo(final ConfigKey.HasConfigKey<T> configKey, final T val) {
        return new Predicate<Location>(){

            public boolean apply(@Nullable Location input) {
                return input != null && Objects.equal((Object)input.getConfig(configKey), (Object)val);
            }
        };
    }

    public static <T> Predicate<Location> isChildOf(final Location parent) {
        return new Predicate<Location>(){

            public boolean apply(@Nullable Location input) {
                return input != null && Objects.equal((Object)input.getParent(), (Object)parent);
            }
        };
    }

    public static <T> Predicate<Location> isDescendantOf(final Location ancestor) {
        return new Predicate<Location>(){

            public boolean apply(@Nullable Location input) {
                Location contenderAncestor;
                Location location = contenderAncestor = input == null ? input : input.getParent();
                while (contenderAncestor != null) {
                    if (Objects.equal((Object)contenderAncestor, (Object)ancestor)) {
                        return true;
                    }
                    contenderAncestor = contenderAncestor.getParent();
                }
                return false;
            }
        };
    }

    public static <T> Predicate<Location> managed() {
        return new Predicate<Location>(){

            public boolean apply(@Nullable Location input) {
                return input != null && Locations.isManaged(input);
            }
        };
    }
}

