/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.basic;

import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.internal.BrooklynFeatureEnablement;
import brooklyn.location.basic.LocationConfigKeys;
import brooklyn.location.basic.LocationInternal;
import brooklyn.location.cloud.CloudLocationConfig;
import brooklyn.management.ManagementContext;
import brooklyn.util.JavaGroovyEquivalents;
import brooklyn.util.ResourceUtils;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.collections.MutableSet;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.crypto.AuthorizedKeysParser;
import brooklyn.util.crypto.SecureKeys;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.os.Os;
import brooklyn.util.text.StringFunctions;
import brooklyn.util.text.Strings;
import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationConfigUtils {
    private static final Logger log = LoggerFactory.getLogger(LocationConfigUtils.class);

    public static OsCredential getOsCredential(ConfigBag config) {
        return OsCredential.newInstance(config);
    }

    @Deprecated
    public static String getPrivateKeyData(ConfigBag config) {
        return LocationConfigUtils.getKeyData(config, LocationConfigKeys.PRIVATE_KEY_DATA, LocationConfigKeys.PRIVATE_KEY_FILE);
    }

    @Deprecated
    public static String getPublicKeyData(ConfigBag config) {
        String data = LocationConfigUtils.getKeyData(config, LocationConfigKeys.PUBLIC_KEY_DATA, LocationConfigKeys.PUBLIC_KEY_FILE);
        if (JavaGroovyEquivalents.groovyTruth((String)data)) {
            return data;
        }
        String privateKeyFile = config.get(LocationConfigKeys.PRIVATE_KEY_FILE);
        if (JavaGroovyEquivalents.groovyTruth((String)privateKeyFile)) {
            List<String> privateKeyFiles = Arrays.asList(privateKeyFile.split(File.pathSeparator));
            ImmutableList publicKeyFiles = ImmutableList.copyOf((Iterable)Iterables.transform(privateKeyFiles, (Function)StringFunctions.append((String)".pub")));
            List<String> publicKeyFilesTidied = LocationConfigUtils.tidyFilePaths((Iterable<String>)publicKeyFiles);
            String fileData = LocationConfigUtils.getFileContents(publicKeyFilesTidied);
            if (JavaGroovyEquivalents.groovyTruth((String)fileData)) {
                if (log.isDebugEnabled()) {
                    log.debug("Loaded " + LocationConfigKeys.PUBLIC_KEY_DATA.getName() + " from inferred files, based on " + LocationConfigKeys.PRIVATE_KEY_FILE.getName() + ": used " + publicKeyFilesTidied + " for " + config.getDescription());
                }
                config.put(LocationConfigKeys.PUBLIC_KEY_DATA, fileData);
                return fileData;
            }
            log.info("Not able to load " + LocationConfigKeys.PUBLIC_KEY_DATA.getName() + " from inferred files, based on " + LocationConfigKeys.PRIVATE_KEY_FILE.getName() + ": tried " + publicKeyFilesTidied + " for " + config.getDescription());
        }
        return null;
    }

    @Deprecated
    public static String getKeyData(ConfigBag config, ConfigKey<String> dataKey, ConfigKey<String> fileKey) {
        return LocationConfigUtils.getKeyDataFromDataKeyOrFileKey(config, dataKey, fileKey);
    }

    private static String getKeyDataFromDataKeyOrFileKey(ConfigBag config, ConfigKey<String> dataKey, ConfigKey<String> fileKey) {
        boolean unused = config.isUnused(dataKey);
        String data = config.get(dataKey);
        if (JavaGroovyEquivalents.groovyTruth((String)data) && !unused) {
            return data;
        }
        String file = config.get(fileKey);
        if (JavaGroovyEquivalents.groovyTruth((String)file)) {
            List<String> files = Arrays.asList(file.split(File.pathSeparator));
            List<String> filesTidied = LocationConfigUtils.tidyFilePaths(files);
            String fileData = LocationConfigUtils.getFileContents(filesTidied);
            if (fileData == null) {
                log.warn("Invalid file" + (files.size() > 1 ? "s" : "") + " for " + fileKey + " (given " + files + (files.equals(filesTidied) ? "" : "; converted to " + filesTidied) + ") " + "may fail provisioning " + config.getDescription());
            } else if (JavaGroovyEquivalents.groovyTruth((String)data)) {
                if (!fileData.trim().equals(data.trim())) {
                    log.warn(dataKey.getName() + " and " + fileKey.getName() + " both specified; preferring the former");
                }
            } else {
                data = fileData;
                config.put(dataKey, data);
                config.get(dataKey);
            }
        }
        return data;
    }

    private static String getFileContents(Iterable<String> files) {
        Iterator<String> fi = files.iterator();
        while (fi.hasNext()) {
            String file = fi.next();
            if (!JavaGroovyEquivalents.groovyTruth((String)file)) continue;
            try {
                String result = ResourceUtils.create().getResourceAsString(file);
                if (result != null) {
                    return result;
                }
                log.debug("Invalid file " + file + " ; " + (!fi.hasNext() ? "no more files to try" : "trying next file") + " (null)");
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                log.debug("Invalid file " + file + " ; " + (!fi.hasNext() ? "no more files to try" : "trying next file"), (Throwable)e);
            }
        }
        return null;
    }

    private static List<String> tidyFilePaths(Iterable<String> files) {
        ArrayList result = Lists.newArrayList();
        for (String file : files) {
            result.add(Os.tidyPath((String)file));
        }
        return result;
    }

    @Deprecated
    public static <T> T getConfigCheckingDeprecatedAlternatives(ConfigBag configBag, ConfigKey<T> preferredKey, ConfigKey<?> ... deprecatedKeys) {
        T value2;
        Object value1 = configBag.getWithDeprecation(preferredKey, deprecatedKeys);
        if (!Objects.equal((Object)value1, value2 = LocationConfigUtils.getConfigCheckingDeprecatedAlternativesInternal(configBag, preferredKey, deprecatedKeys))) {
            log.warn("Deprecated getConfig with deprecated keys " + Arrays.toString(deprecatedKeys) + " gets different value with " + "new strategy " + preferredKey + " (" + value1 + ") and old (" + value2 + "); preferring old value for now, but this behaviour will change");
            return value2;
        }
        return (T)value1;
    }

    private static <T> T getConfigCheckingDeprecatedAlternativesInternal(ConfigBag configBag, ConfigKey<T> preferredKey, ConfigKey<?> ... deprecatedKeys) {
        Object keyProvidingValue = null;
        Object value = null;
        boolean found = false;
        if (configBag.containsKey(preferredKey)) {
            value = configBag.get(preferredKey);
            found = true;
            keyProvidingValue = preferredKey;
        }
        for (ConfigKey<?> deprecatedKey : deprecatedKeys) {
            Object altValue = null;
            boolean altFound = false;
            if (!configBag.containsKey(deprecatedKey)) continue;
            altValue = configBag.get(deprecatedKey);
            altFound = true;
            if (!altFound) continue;
            if (found) {
                if (Objects.equal(value, altValue)) continue;
                log.warn("Detected deprecated key " + deprecatedKey + " with value " + altValue + " used in addition to " + keyProvidingValue + " " + "with value " + value + " for " + configBag.getDescription() + "; ignoring");
                configBag.remove(deprecatedKey);
                continue;
            }
            log.warn("Detected deprecated key " + deprecatedKey + " with value " + altValue + " used instead of recommended " + preferredKey + "; " + "promoting to preferred key status; will not be supported in future versions");
            configBag.put(preferredKey, altValue);
            configBag.remove(deprecatedKey);
            value = altValue;
            found = true;
            keyProvidingValue = deprecatedKey;
        }
        if (found) {
            return value;
        }
        return configBag.get(preferredKey);
    }

    public static Map<ConfigKey<String>, String> finalAndOriginalSpecs(String finalSpec, Object ... sourcesForOriginalSpec) {
        MutableMap result = MutableMap.of();
        if (finalSpec != null) {
            result.put(LocationInternal.FINAL_SPEC, finalSpec);
        }
        String originalSpec = null;
        for (Object source : sourcesForOriginalSpec) {
            if (source instanceof CharSequence) {
                originalSpec = source.toString();
            } else if (source instanceof Map) {
                if (originalSpec == null) {
                    originalSpec = Strings.toString(((Map)source).get(LocationInternal.ORIGINAL_SPEC));
                }
                if (originalSpec == null) {
                    originalSpec = Strings.toString(((Map)source).get(LocationInternal.ORIGINAL_SPEC.getName()));
                }
            }
            if (originalSpec != null) break;
        }
        if (originalSpec == null) {
            originalSpec = finalSpec;
        }
        if (originalSpec != null) {
            result.put(LocationInternal.ORIGINAL_SPEC, originalSpec);
        }
        return result;
    }

    public static boolean isEnabled(ManagementContext mgmt, String prefix) {
        ConfigKey<Boolean> key = ConfigKeys.newConfigKeyWithPrefix(prefix + ".", LocationConfigKeys.ENABLED);
        Boolean enabled = (Boolean)mgmt.getConfig().getConfig(key);
        if (enabled != null) {
            return enabled;
        }
        return true;
    }

    @Beta
    public static class OsCredential {
        private final ConfigBag config;
        private boolean preferPassword = false;
        private boolean tryDefaultKeys = true;
        private boolean requirePublicKey = true;
        private boolean doKeyValidation = BrooklynFeatureEnablement.isEnabled("brooklyn.validate.locationSshKeys");
        private boolean warnOnErrors = true;
        private boolean throwOnErrors = false;
        private boolean dirty = true;
        private String privateKeyData;
        private String publicKeyData;
        private String password;
        Set<String> warningMessages = MutableSet.of();

        private OsCredential(ConfigBag config) {
            this.config = config;
        }

        public OsCredential checkNotEmpty() {
            this.checkNoErrors();
            if (!this.hasKey() && !this.hasPassword()) {
                if (this.warningMessages.size() > 0) {
                    throw new IllegalStateException("Could not find credentials: " + this.warningMessages);
                }
                throw new IllegalStateException("Could not find credentials");
            }
            return this;
        }

        public OsCredential checkNoErrors() {
            this.throwOnErrors(true);
            this.dirty();
            this.infer();
            return this;
        }

        public OsCredential logAnyWarnings() {
            if (!this.warningMessages.isEmpty()) {
                log.warn("When reading credentials: " + this.warningMessages);
            }
            return this;
        }

        public Set<String> getWarningMessages() {
            return this.warningMessages;
        }

        public synchronized String getPreferredCredential() {
            this.infer();
            if (this.isUsingPassword()) {
                return this.password;
            }
            if (this.hasKey()) {
                return this.privateKeyData;
            }
            return null;
        }

        public boolean isEmpty() {
            return !this.hasKey() && !this.hasPassword();
        }

        public boolean hasKey() {
            this.infer();
            return Strings.isNonBlank((CharSequence)this.privateKeyData);
        }

        public boolean hasPassword() {
            this.infer();
            return this.password != null;
        }

        public boolean isUsingPassword() {
            return this.hasPassword() && (!this.hasKey() || this.preferPassword);
        }

        public String getPrivateKeyData() {
            this.infer();
            return this.privateKeyData;
        }

        public String getPublicKeyData() {
            this.infer();
            return this.publicKeyData;
        }

        public String getPassword() {
            this.infer();
            return this.password;
        }

        public OsCredential preferKey() {
            this.preferPassword = false;
            return this.dirty();
        }

        public OsCredential preferPassword() {
            this.preferPassword = true;
            return this.dirty();
        }

        public OsCredential requirePublicKey(boolean requirePublicKey) {
            this.requirePublicKey = requirePublicKey;
            return this.dirty();
        }

        public OsCredential doKeyValidation(boolean doKeyValidation) {
            this.doKeyValidation = doKeyValidation;
            return this.dirty();
        }

        public OsCredential useDefaultKeys(boolean tryDefaultKeys) {
            this.tryDefaultKeys = tryDefaultKeys;
            return this.dirty();
        }

        public OsCredential warnOnErrors(boolean warnOnErrors) {
            this.warnOnErrors = warnOnErrors;
            return this.dirty();
        }

        public OsCredential throwOnErrors(boolean throwOnErrors) {
            this.throwOnErrors = throwOnErrors;
            return this.dirty();
        }

        private OsCredential dirty() {
            this.dirty = true;
            return this;
        }

        public static OsCredential newInstance(ConfigBag config) {
            return new OsCredential(config);
        }

        private synchronized void infer() {
            if (!this.dirty) {
                return;
            }
            this.warningMessages.clear();
            log.debug("Inferring OS credentials");
            this.privateKeyData = this.config.get(LocationConfigKeys.PRIVATE_KEY_DATA);
            this.password = this.config.get(LocationConfigKeys.PASSWORD);
            this.publicKeyData = LocationConfigUtils.getKeyDataFromDataKeyOrFileKey(this.config, (ConfigKey<String>)LocationConfigKeys.PUBLIC_KEY_DATA, (ConfigKey<String>)LocationConfigKeys.PUBLIC_KEY_FILE);
            KeyPair privateKey = null;
            if (Strings.isBlank((CharSequence)this.privateKeyData)) {
                String privateKeyFiles = null;
                boolean privateKeyFilesExplicitlySet = this.config.containsKey(LocationConfigKeys.PRIVATE_KEY_FILE);
                if (privateKeyFilesExplicitlySet || this.tryDefaultKeys && this.password == null) {
                    privateKeyFiles = this.config.get(LocationConfigKeys.PRIVATE_KEY_FILE);
                }
                if (Strings.isNonBlank(privateKeyFiles)) {
                    Iterator<String> fi = Arrays.asList(privateKeyFiles.split(File.pathSeparator)).iterator();
                    while (fi.hasNext()) {
                        String file = fi.next();
                        if (!Strings.isNonBlank((CharSequence)file)) continue;
                        try {
                            if (file != null) {
                                this.privateKeyData = ResourceUtils.create().getResourceAsString(file);
                            }
                            privateKey = this.getValidatedPrivateKey(file);
                            if (this.privateKeyData == null) continue;
                            if (Strings.isNonBlank((CharSequence)this.publicKeyData)) {
                                log.debug("Loaded private key data from " + file + " (public key data explicitly set)");
                                break;
                            }
                            String publicKeyFile = file != null ? file + ".pub" : "(data)";
                            try {
                                this.publicKeyData = ResourceUtils.create().getResourceAsString(publicKeyFile);
                                log.debug("Loaded private key data from " + file + " and public key data from " + publicKeyFile);
                                break;
                            }
                            catch (Exception e) {
                                Exceptions.propagateIfFatal((Throwable)e);
                                log.debug("No public key file " + publicKeyFile + "; will try extracting from private key");
                                this.publicKeyData = AuthorizedKeysParser.encodePublicKey((PublicKey)privateKey.getPublic());
                                if (this.publicKeyData == null) {
                                    if (!this.requirePublicKey) {
                                        log.debug("Loaded private key data from " + file + " (public key data not found but not required)");
                                        break;
                                    }
                                } else {
                                    log.debug("Loaded private key data from " + file + " (public key data extracted)");
                                    break;
                                }
                                this.addWarning("Unable to find or extract public key for " + file, "skipping");
                                this.privateKeyData = null;
                            }
                        }
                        catch (Exception e) {
                            Exceptions.propagateIfFatal((Throwable)e);
                            String message = "Missing/invalid private key file " + file;
                            if (!privateKeyFilesExplicitlySet) continue;
                            this.addWarning(message, (!fi.hasNext() ? "no more files to try" : "trying next file") + ": " + e);
                        }
                    }
                    if (privateKeyFilesExplicitlySet && Strings.isBlank((CharSequence)this.privateKeyData)) {
                        this.error("No valid private keys found", "" + this.warningMessages);
                    }
                }
            } else {
                privateKey = this.getValidatedPrivateKey("(data)");
            }
            if (this.privateKeyData != null) {
                if (this.requirePublicKey && Strings.isBlank((CharSequence)this.publicKeyData)) {
                    if (privateKey != null) {
                        this.publicKeyData = AuthorizedKeysParser.encodePublicKey((PublicKey)privateKey.getPublic());
                    }
                    if (Strings.isBlank((CharSequence)this.publicKeyData)) {
                        this.error("If explicit " + LocationConfigKeys.PRIVATE_KEY_DATA.getName() + " is supplied, then " + "the corresponding " + LocationConfigKeys.PUBLIC_KEY_DATA.getName() + " must also be supplied.", null);
                    } else {
                        log.debug("Public key data extracted");
                    }
                }
                if (this.doKeyValidation && privateKey != null && privateKey.getPublic() != null && Strings.isNonBlank((CharSequence)this.publicKeyData)) {
                    PublicKey decoded = null;
                    try {
                        decoded = AuthorizedKeysParser.decodePublicKey((String)this.publicKeyData);
                    }
                    catch (Exception e) {
                        Exceptions.propagateIfFatal((Throwable)e);
                        this.addWarning("Invalid public key: " + decoded);
                    }
                    if (decoded != null && !privateKey.getPublic().equals(decoded)) {
                        this.error("Public key inferred from does not match public key extracted from private key", null);
                    }
                }
            }
            log.debug("OS credential inference: " + this);
            this.dirty = false;
        }

        private KeyPair getValidatedPrivateKey(String label) {
            KeyPair privateKey;
            block7: {
                privateKey = null;
                String passphrase = this.config.get(CloudLocationConfig.PRIVATE_KEY_PASSPHRASE);
                try {
                    privateKey = SecureKeys.readPem(new ByteArrayInputStream(this.privateKeyData.getBytes()), passphrase);
                    if (passphrase != null) {
                        this.privateKeyData = SecureKeys.toPem(privateKey);
                    }
                }
                catch (SecureKeys.PassphraseProblem e) {
                    if (this.doKeyValidation) {
                        log.debug("Encountered error handling key " + label + ": " + e, (Throwable)e);
                        if (Strings.isBlank((CharSequence)passphrase)) {
                            this.addWarning("Passphrase required for key '" + label + "'");
                        } else {
                            this.addWarning("Invalid passphrase for key '" + label + "'");
                        }
                        this.privateKeyData = null;
                    }
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                    if (!this.doKeyValidation) break block7;
                    this.addWarning("Unable to parse private key from '" + label + "': unknown format");
                    this.privateKeyData = null;
                }
            }
            return privateKey;
        }

        private void error(String msg, String logExtension) {
            this.addWarning(msg);
            if (this.warnOnErrors) {
                log.warn(msg + (logExtension == null ? "" : ": " + logExtension));
            }
            if (this.throwOnErrors) {
                throw new IllegalStateException(msg + (logExtension == null ? "" : "; " + logExtension));
            }
        }

        private void addWarning(String msg) {
            this.addWarning(msg, null);
        }

        private void addWarning(String msg, String debugExtension) {
            log.debug(msg + (debugExtension == null ? "" : "; " + debugExtension));
            this.warningMessages.add(msg);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + (Strings.isNonBlank((CharSequence)this.publicKeyData) ? this.publicKeyData : "no-public-key") + ";" + (Strings.isNonBlank((CharSequence)this.privateKeyData) ? "private-key-present" : "no-private-key") + "," + (this.password != null ? "password(len=" + this.password.length() + ")" : "no-password") + "]";
        }
    }
}

