/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.basic;

import brooklyn.location.basic.LocationPropertiesFromBrooklynProperties;
import brooklyn.util.config.ConfigBag;
import com.google.common.base.Strings;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalhostPropertiesFromBrooklynProperties
extends LocationPropertiesFromBrooklynProperties {
    private static final Logger LOG = LoggerFactory.getLogger(LocalhostPropertiesFromBrooklynProperties.class);

    @Override
    public Map<String, Object> getLocationProperties(String provider, String namedLocation, Map<String, ?> properties) {
        if (Strings.isNullOrEmpty((String)namedLocation) && Strings.isNullOrEmpty((String)provider)) {
            throw new IllegalArgumentException("Neither cloud provider/API nor location name have been specified correctly");
        }
        ConfigBag result = ConfigBag.newInstance();
        result.putAll(this.transformDeprecated(this.getGenericLocationSingleWordProperties(properties)));
        result.putAll(this.transformDeprecated(this.getMatchingSingleWordProperties("brooklyn.location.", properties)));
        result.putAll(this.transformDeprecated(this.getMatchingProperties("brooklyn.location.localhost.", "brooklyn.localhost.", properties)));
        if (!Strings.isNullOrEmpty((String)namedLocation)) {
            result.putAll(this.transformDeprecated(this.getNamedLocationProperties(namedLocation, properties)));
        }
        LocalhostPropertiesFromBrooklynProperties.setLocalTempDir(properties, result);
        return result.getAllConfigRaw();
    }
}

