/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.basic;

import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.BrooklynConfigKeys;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.rebind.persister.FileBasedObjectStore;
import brooklyn.entity.rebind.persister.LocationWithObjectStore;
import brooklyn.entity.rebind.persister.PersistenceObjectStore;
import brooklyn.location.AddressableLocation;
import brooklyn.location.LocationSpec;
import brooklyn.location.OsDetails;
import brooklyn.location.PortRange;
import brooklyn.location.basic.BasicOsDetails;
import brooklyn.location.basic.FixedListMachineProvisioningLocation;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.location.geo.HostGeoInfo;
import brooklyn.util.BrooklynNetworkUtils;
import brooklyn.util.GroovyJavaMethods;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.internal.ssh.process.ProcessTool;
import brooklyn.util.mutex.MutexSupport;
import brooklyn.util.mutex.WithMutexes;
import brooklyn.util.net.Networking;
import brooklyn.util.os.Os;
import brooklyn.util.ssh.BashCommands;
import brooklyn.util.time.Duration;
import brooklyn.util.time.Time;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalhostMachineProvisioningLocation
extends FixedListMachineProvisioningLocation<SshMachineLocation>
implements AddressableLocation,
LocationWithObjectStore {
    public static final Logger LOG = LoggerFactory.getLogger(LocalhostMachineProvisioningLocation.class);
    public static final ConfigKey<Boolean> SKIP_ON_BOX_BASE_DIR_RESOLUTION = ConfigKeys.newConfigKeyWithDefault(BrooklynConfigKeys.SKIP_ON_BOX_BASE_DIR_RESOLUTION, true);
    @SetFromFlag(value="count")
    int initialCount;
    @SetFromFlag
    Boolean canProvisionMore;
    @SetFromFlag
    InetAddress address;
    private static Set<Integer> portsInUse = Sets.newLinkedHashSet();
    private static HostGeoInfo cachedHostGeoInfo;

    @VisibleForTesting
    public static void clearStaticData() {
        portsInUse.clear();
        cachedHostGeoInfo = null;
    }

    public LocalhostMachineProvisioningLocation() {
        this((Map)Maps.newLinkedHashMap());
    }

    public LocalhostMachineProvisioningLocation(Map properties) {
        super(properties);
    }

    public LocalhostMachineProvisioningLocation(String name) {
        this(name, 0);
    }

    public LocalhostMachineProvisioningLocation(String name, int count) {
        this((Map)MutableMap.of((Object)"name", (Object)name, (Object)"count", (Object)count));
    }

    public static LocationSpec<LocalhostMachineProvisioningLocation> spec() {
        return LocationSpec.create(LocalhostMachineProvisioningLocation.class);
    }

    @Override
    public LocalhostMachineProvisioningLocation configure(Map<?, ?> flags) {
        super.configure((Map)flags);
        if (!GroovyJavaMethods.truth((Object)this.getDisplayName())) {
            this.setDisplayName("localhost");
        }
        if (!GroovyJavaMethods.truth((Object)this.address)) {
            this.address = LocalhostMachineProvisioningLocation.getLocalhostInetAddress();
        }
        if (this.canProvisionMore == null) {
            this.canProvisionMore = this.initialCount > 0 ? Boolean.valueOf(false) : Boolean.valueOf(true);
        }
        if (this.getHostGeoInfo() == null) {
            if (cachedHostGeoInfo == null) {
                cachedHostGeoInfo = HostGeoInfo.fromLocation(this);
            }
            this.setHostGeoInfo(cachedHostGeoInfo);
        }
        if (this.initialCount > this.getMachines().size()) {
            this.provisionMore(this.initialCount - this.getMachines().size());
        }
        if (this.getConfig(BrooklynConfigKeys.ONBOX_BASE_DIR) == null && (this.getManagementContext() == null || this.getManagementContext().getConfig().getConfig(BrooklynConfigKeys.ONBOX_BASE_DIR) == null)) {
            this.setConfig(BrooklynConfigKeys.ONBOX_BASE_DIR, "/tmp/brooklyn-" + Os.user());
        }
        return this;
    }

    public static InetAddress getLocalhostInetAddress() {
        return BrooklynNetworkUtils.getLocalhostInetAddress();
    }

    public InetAddress getAddress() {
        return this.address;
    }

    @Override
    public boolean canProvisionMore() {
        return this.canProvisionMore;
    }

    @Override
    protected void provisionMore(int size, Map<?, ?> flags) {
        for (int i = 0; i < size; ++i) {
            MutableMap flags2 = MutableMap.builder().putAll(flags).put((Object)"address", GroovyJavaMethods.elvis((Object)this.address, (Object)Networking.getLocalHost())).put((Object)"mutexSupport", (Object)LocalhostMachine.mutexSupport).build();
            for (ConfigKey.HasConfigKey<?> k : SshMachineLocation.ALL_SSH_CONFIG_KEYS) {
                if (!this.config().getRaw(k).isPresent()) continue;
                flags2.put(k, this.getConfig(k));
            }
            if (this.isManaged()) {
                this.addChild(LocationSpec.create(LocalhostMachine.class).configure((Map)flags2));
                continue;
            }
            this.addChild(new LocalhostMachine((Map)flags2));
        }
    }

    public static synchronized boolean obtainSpecificPort(InetAddress localAddress, int portNumber) {
        if (portsInUse.contains(portNumber)) {
            return false;
        }
        if (!LocalhostMachineProvisioningLocation.checkPortAvailable(localAddress, portNumber)) {
            return false;
        }
        portsInUse.add(portNumber);
        return true;
    }

    public static boolean checkPortAvailable(InetAddress localAddress, int portNumber) {
        if (portNumber < 1024) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Skipping system availability check for privileged localhost port " + portNumber);
            }
            return true;
        }
        return Networking.isPortAvailable((InetAddress)localAddress, (int)portNumber);
    }

    public static int obtainPort(PortRange range) {
        return LocalhostMachineProvisioningLocation.obtainPort(LocalhostMachineProvisioningLocation.getLocalhostInetAddress(), range);
    }

    public static int obtainPort(InetAddress localAddress, PortRange range) {
        Iterator i$ = range.iterator();
        while (i$.hasNext()) {
            int p = (Integer)i$.next();
            if (!LocalhostMachineProvisioningLocation.obtainSpecificPort(localAddress, p)) continue;
            return p;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("unable to find port in {} on {}; returning -1", (Object)range, (Object)localAddress);
        }
        return -1;
    }

    public static synchronized void releasePort(InetAddress localAddress, int portNumber) {
        portsInUse.remove(portNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(SshMachineLocation machine) {
        LocalhostMachine localMachine = (LocalhostMachine)machine;
        LinkedHashSet portsObtained = Sets.newLinkedHashSet();
        Set set = localMachine.portsObtained;
        synchronized (set) {
            portsObtained.addAll(localMachine.portsObtained);
        }
        super.release(machine);
        Iterator i$ = portsObtained.iterator();
        while (i$.hasNext()) {
            int p = (Integer)i$.next();
            LocalhostMachineProvisioningLocation.releasePort(null, p);
        }
    }

    public static boolean isSudoAllowed() {
        return SudoChecker.isSudoAllowed();
    }

    @Override
    public PersistenceObjectStore newPersistenceObjectStore(String container) {
        File basedir = new File(container);
        if (basedir.isFile()) {
            throw new IllegalArgumentException("Destination directory must not be a file");
        }
        return new FileBasedObjectStore(basedir);
    }

    private static class SudoChecker {
        static volatile long lastSudoCheckTime = -1L;
        static boolean lastSudoResult = false;

        private SudoChecker() {
        }

        public static boolean isSudoAllowed() {
            if (Time.hasElapsedSince((long)lastSudoCheckTime, (Duration)Duration.FIVE_MINUTES)) {
                SudoChecker.checkIfNeeded();
            }
            return lastSudoResult;
        }

        private static synchronized void checkIfNeeded() {
            if (Time.hasElapsedSince((long)lastSudoCheckTime, (Duration)Duration.FIVE_MINUTES)) {
                try {
                    lastSudoResult = new ProcessTool().execCommands((Map<String, ?>)MutableMap.of(), Arrays.asList(BashCommands.sudo((String)"date"))) == 0;
                }
                catch (Exception e) {
                    lastSudoResult = false;
                    LOG.debug("Error checking sudo at localhost: " + e, (Throwable)e);
                }
                lastSudoCheckTime = System.currentTimeMillis();
            }
        }
    }

    public static class LocalhostMachine
    extends SshMachineLocation {
        public static final ConfigKey<Boolean> SKIP_ON_BOX_BASE_DIR_RESOLUTION = ConfigKeys.newConfigKeyWithDefault(BrooklynConfigKeys.SKIP_ON_BOX_BASE_DIR_RESOLUTION, true);
        private static final WithMutexes mutexSupport = new MutexSupport();
        private final Set<Integer> portsObtained = Sets.newLinkedHashSet();

        public LocalhostMachine() {
        }

        public LocalhostMachine(Map properties) {
            super((Map)MutableMap.builder().putAll(properties).put((Object)"mutexSupport", (Object)mutexSupport).build());
        }

        @Override
        protected WithMutexes getMutexSupport() {
            return mutexSupport;
        }

        @Override
        public boolean obtainSpecificPort(int portNumber) {
            if (!LocalhostMachineProvisioningLocation.isSudoAllowed() && portNumber <= 1024) {
                return false;
            }
            return LocalhostMachineProvisioningLocation.obtainSpecificPort(this.getAddress(), portNumber);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int obtainPort(PortRange range) {
            int r = LocalhostMachineProvisioningLocation.obtainPort(this.getAddress(), range);
            Set<Integer> set = this.portsObtained;
            synchronized (set) {
                if (r > 0) {
                    this.portsObtained.add(r);
                }
            }
            LOG.debug("localhost.obtainPort(" + range + "), returning " + r);
            return r;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void releasePort(int portNumber) {
            Set<Integer> set = this.portsObtained;
            synchronized (set) {
                this.portsObtained.remove(portNumber);
            }
            LocalhostMachineProvisioningLocation.releasePort(this.getAddress(), portNumber);
        }

        @Override
        public OsDetails getOsDetails() {
            return BasicOsDetails.Factory.newLocalhostInstance();
        }

        @Override
        public LocalhostMachine configure(Map<?, ?> properties) {
            if (this.address == null || !properties.containsKey("address")) {
                this.address = Networking.getLocalHost();
            }
            super.configure((Map)properties);
            return this;
        }
    }
}

