/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.basic;

import brooklyn.location.Location;
import brooklyn.location.LocationRegistry;
import brooklyn.location.LocationResolver;
import brooklyn.location.basic.AbstractLocationResolver;
import brooklyn.location.basic.LocalhostMachineProvisioningLocation;
import brooklyn.location.basic.LocalhostPropertiesFromBrooklynProperties;
import brooklyn.location.basic.LocationConfigUtils;
import brooklyn.util.config.ConfigBag;
import java.util.Map;

public class LocalhostLocationResolver
extends AbstractLocationResolver
implements LocationResolver.EnableableLocationResolver {
    public static final String LOCALHOST = "localhost";

    public String getPrefix() {
        return LOCALHOST;
    }

    public boolean isEnabled() {
        return LocationConfigUtils.isEnabled(this.managementContext, "brooklyn.location.localhost");
    }

    @Override
    protected Class<? extends Location> getLocationType() {
        return LocalhostMachineProvisioningLocation.class;
    }

    @Override
    protected AbstractLocationResolver.SpecParser getSpecParser() {
        return new AbstractLocationResolver.SpecParser(this.getPrefix()).setExampleUsage("\"localhost\" or \"localhost(displayName=abc)\"");
    }

    @Override
    protected Map<String, Object> getFilteredLocationProperties(String provider, String namedLocation, Map<String, ?> globalProperties) {
        return new LocalhostPropertiesFromBrooklynProperties().getLocationProperties(LOCALHOST, namedLocation, globalProperties);
    }

    @Override
    protected ConfigBag extractConfig(Map<?, ?> locationFlags, String spec, LocationRegistry registry) {
        ConfigBag config = super.extractConfig(locationFlags, spec, registry);
        config.putAsStringKeyIfAbsent("name", LOCALHOST);
        return config;
    }
}

