/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.basic;

import brooklyn.location.Location;
import brooklyn.location.LocationRegistry;
import brooklyn.location.LocationSpec;
import brooklyn.location.basic.AbstractLocationResolver;
import brooklyn.location.basic.LocationConfigUtils;
import brooklyn.location.basic.LocationInternal;
import brooklyn.location.basic.LocationPropertiesFromBrooklynProperties;
import brooklyn.location.basic.SingleMachineProvisioningLocation;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.guava.Maybe;
import brooklyn.util.text.KeyValueParser;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Map;

public class HostLocationResolver
extends AbstractLocationResolver {
    private static final String HOST = "host";

    @Override
    public Location newLocationFromString(Map locationFlags, String spec, LocationRegistry registry) {
        AbstractLocationResolver.SpecParser.ParsedSpec parsedSpec = this.specParser.parse(spec);
        ImmutableMap argsMap = parsedSpec.argsMap;
        if (argsMap.isEmpty()) {
            throw new IllegalArgumentException("Invalid host spec (no host supplied): " + spec);
        }
        if (argsMap.size() == 1 && Iterables.get(argsMap.values(), (int)0) == null) {
            argsMap = ImmutableMap.of((Object)"hosts", (Object)Iterables.get(argsMap.keySet(), (int)0));
        } else if (!argsMap.containsKey(HOST) && !argsMap.containsKey("hosts")) {
            throw new IllegalArgumentException("Invalid host spec (no host supplied): " + spec);
        }
        Map globalProperties = registry.getProperties();
        String namedLocation = (String)locationFlags.get(LocationInternal.NAMED_SPEC_NAME.getName());
        Map<String, Object> filteredProperties = new LocationPropertiesFromBrooklynProperties().getLocationProperties(null, namedLocation, globalProperties);
        ConfigBag flags = ConfigBag.newInstance(locationFlags).putIfAbsent(filteredProperties);
        flags.remove(LocationInternal.NAMED_SPEC_NAME);
        String target = "byon(" + KeyValueParser.toLine((Map)argsMap) + ")";
        Maybe testResolve = this.managementContext.getLocationRegistry().resolve(target, Boolean.valueOf(false), null);
        if (!testResolve.isPresent()) {
            throw new IllegalArgumentException("Invalid target location '" + target + "' for location '" + HOST + "': " + Exceptions.collapseText((Throwable)((Maybe.Absent)testResolve).getException()), ((Maybe.Absent)testResolve).getException());
        }
        return this.managementContext.getLocationManager().createLocation(LocationSpec.create(SingleMachineProvisioningLocation.class).configure((CharSequence)"location", (Object)target).configure((CharSequence)"locationFlags", flags.getAllConfig()).configure(LocationConfigUtils.finalAndOriginalSpecs(spec, locationFlags, globalProperties, namedLocation)));
    }

    public String getPrefix() {
        return HOST;
    }

    @Override
    protected Class<? extends Location> getLocationType() {
        return SingleMachineProvisioningLocation.class;
    }

    @Override
    protected AbstractLocationResolver.SpecParser getSpecParser() {
        return new AbstractLocationResolver.SpecParser(this.getPrefix()).setExampleUsage("\"host(1.1.1.1)\" or \"host(host=1.1.1.1,name=myname)\"");
    }
}

