/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.basic;

import brooklyn.location.Location;
import brooklyn.location.LocationDefinition;
import brooklyn.location.LocationRegistry;
import brooklyn.location.LocationResolver;
import brooklyn.location.basic.BasicLocationRegistry;
import brooklyn.management.ManagementContext;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefinedLocationByIdResolver
implements LocationResolver {
    public static final Logger log = LoggerFactory.getLogger(DefinedLocationByIdResolver.class);
    public static final String ID = "id";
    private volatile ManagementContext managementContext;

    public void init(ManagementContext managementContext) {
        this.managementContext = (ManagementContext)Preconditions.checkNotNull((Object)managementContext, (Object)"managementContext");
    }

    public Location newLocationFromString(Map locationFlags, String spec, LocationRegistry registry) {
        String id = spec;
        if (spec.toLowerCase().startsWith("id:")) {
            id = spec.substring("id:".length());
        }
        LocationDefinition ld = registry.getDefinedLocationById(id);
        ld.getSpec();
        return ((BasicLocationRegistry)registry).resolveLocationDefinition(ld, locationFlags, null);
    }

    public String getPrefix() {
        return ID;
    }

    public boolean accepts(String spec, LocationRegistry registry) {
        if (BasicLocationRegistry.isResolverPrefixForSpec(this, spec, false)) {
            return true;
        }
        return registry.getDefinedLocationById(spec) != null;
    }
}

