/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.basic;

import brooklyn.catalog.CatalogItem;
import brooklyn.catalog.internal.CatalogUtils;
import brooklyn.location.Location;
import brooklyn.location.LocationRegistry;
import brooklyn.location.LocationResolver;
import brooklyn.location.LocationSpec;
import brooklyn.location.basic.BasicLocationRegistry;
import brooklyn.management.ManagementContext;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogLocationResolver
implements LocationResolver {
    private static final Logger log = LoggerFactory.getLogger(CatalogLocationResolver.class);
    public static final String NAME = "brooklyn.catalog";
    private ManagementContext managementContext;

    public void init(ManagementContext managementContext) {
        this.managementContext = (ManagementContext)Preconditions.checkNotNull((Object)managementContext, (Object)"managementContext");
    }

    public Location newLocationFromString(Map locationFlags, String spec, LocationRegistry registry) {
        String id = spec.substring(NAME.length() + 1);
        CatalogItem<?, ?> item = CatalogUtils.getCatalogItemOptionalVersion(this.managementContext, id);
        LocationSpec origLocSpec = (LocationSpec)this.managementContext.getCatalog().createSpec(item);
        LocationSpec locSpec = LocationSpec.create((LocationSpec)origLocSpec).configure(locationFlags);
        return this.managementContext.getLocationManager().createLocation(locSpec);
    }

    public String getPrefix() {
        return NAME;
    }

    public boolean accepts(String spec, LocationRegistry registry) {
        if (BasicLocationRegistry.isResolverPrefixForSpec(this, spec, false)) {
            return true;
        }
        return registry.getDefinedLocationByName(spec) != null;
    }
}

