/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.basic;

import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.location.Location;
import brooklyn.location.LocationRegistry;
import brooklyn.location.LocationSpec;
import brooklyn.location.MachineLocation;
import brooklyn.location.basic.AbstractLocationResolver;
import brooklyn.location.basic.FixedListMachineProvisioningLocation;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.location.basic.WinRmMachineLocation;
import brooklyn.management.internal.LocalLocationManager;
import brooklyn.util.JavaGroovyEquivalents;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.text.WildcardGlobs;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByonLocationResolver
extends AbstractLocationResolver {
    public static final Logger log = LoggerFactory.getLogger(ByonLocationResolver.class);
    public static final String BYON = "byon";
    public static final ConfigKey<String> OS_FAMILY = ConfigKeys.newStringConfigKey("osfamily", "OS Family of the machine, either windows or linux", "linux");
    public static final Map<String, Class<? extends MachineLocation>> OS_TO_MACHINE_LOCATION_TYPE = ImmutableMap.of((Object)"windows", WinRmMachineLocation.class, (Object)"linux", SshMachineLocation.class);

    public String getPrefix() {
        return BYON;
    }

    @Override
    protected Class<? extends Location> getLocationType() {
        return FixedListMachineProvisioningLocation.class;
    }

    @Override
    protected AbstractLocationResolver.SpecParser getSpecParser() {
        return new AbstractLocationResolver.SpecParser(this.getPrefix()).setExampleUsage("\"byon(hosts='addr1,addr2')\"");
    }

    @Override
    protected ConfigBag extractConfig(Map<?, ?> locationFlags, String spec, LocationRegistry registry) {
        Object hostAddresses;
        ConfigBag config = super.extractConfig(locationFlags, spec, registry);
        Object hosts = config.getStringKey("hosts");
        config.remove("hosts");
        String user = (String)config.getStringKey("user");
        Class<? extends MachineLocation> locationClass = OS_TO_MACHINE_LOCATION_TYPE.get(config.get(OS_FAMILY));
        if (hosts instanceof String) {
            hostAddresses = ((String)hosts).isEmpty() ? ImmutableList.of() : WildcardGlobs.getGlobsAfterBraceExpansion((String)("{" + hosts + "}"), (boolean)true, (WildcardGlobs.PhraseTreatment)WildcardGlobs.PhraseTreatment.NOT_A_SPECIAL_CHAR, (WildcardGlobs.PhraseTreatment)WildcardGlobs.PhraseTreatment.NOT_A_SPECIAL_CHAR);
        } else if (hosts instanceof Iterable) {
            hostAddresses = ImmutableList.copyOf((Iterable)((Iterable)hosts));
        } else {
            throw new IllegalArgumentException("Invalid location '" + spec + "'; at least one host must be defined");
        }
        if (hostAddresses.isEmpty()) {
            throw new IllegalArgumentException("Invalid location '" + spec + "'; at least one host must be defined");
        }
        ArrayList machines = Lists.newArrayList();
        for (String host : hostAddresses) {
            String userHere = user;
            String hostHere = host;
            if (host.contains("@")) {
                userHere = host.substring(0, host.indexOf("@"));
                hostHere = host.substring(host.indexOf("@") + 1);
            }
            try {
                InetAddress.getByName(hostHere.trim());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid host '" + hostHere + "' specified in '" + spec + "': " + e);
            }
            LocationSpec locationSpec = LocationSpec.create(locationClass).configure((CharSequence)"address", (Object)hostHere.trim()).configureIfNotNull(LocalLocationManager.CREATE_UNMANAGED, (Object)config.get(LocalLocationManager.CREATE_UNMANAGED));
            if (JavaGroovyEquivalents.groovyTruth((String)userHere)) {
                locationSpec.configure((CharSequence)"user", (Object)userHere.trim());
            }
            MachineLocation machine = (MachineLocation)this.managementContext.getLocationManager().createLocation(locationSpec);
            machines.add(machine);
        }
        config.putStringKey("machines", machines);
        return config;
    }
}

