/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.basic;

import brooklyn.location.HardwareDetails;
import brooklyn.location.MachineDetails;
import brooklyn.location.OsDetails;
import brooklyn.location.basic.BasicHardwareDetails;
import brooklyn.location.basic.BasicOsDetails;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.management.Task;
import brooklyn.util.ResourceUtils;
import brooklyn.util.stream.Streams;
import brooklyn.util.task.DynamicTasks;
import brooklyn.util.task.TaskTags;
import brooklyn.util.task.ssh.internal.AbstractSshExecTaskFactory;
import brooklyn.util.task.ssh.internal.PlainSshExecTaskFactory;
import brooklyn.util.task.system.ProcessTaskWrapper;
import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.common.io.CharStreams;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class BasicMachineDetails
implements MachineDetails {
    public static final Logger LOG = LoggerFactory.getLogger(BasicMachineDetails.class);
    private final HardwareDetails hardwareDetails;
    private final OsDetails osDetails;

    public BasicMachineDetails(HardwareDetails hardwareDetails, OsDetails osDetails) {
        this.hardwareDetails = (HardwareDetails)Preconditions.checkNotNull((Object)hardwareDetails, (Object)"hardwareDetails");
        this.osDetails = (OsDetails)Preconditions.checkNotNull((Object)osDetails, (Object)"osDetails");
    }

    @Nonnull
    public HardwareDetails getHardwareDetails() {
        return this.hardwareDetails;
    }

    @Nonnull
    public OsDetails getOsDetails() {
        return this.osDetails;
    }

    public String toString() {
        return Objects.toStringHelper(MachineDetails.class).add("os", (Object)this.osDetails).add("hardware", (Object)this.hardwareDetails).toString();
    }

    static BasicMachineDetails forSshMachineLocation(SshMachineLocation location) {
        return (BasicMachineDetails)TaskTags.markInessential(DynamicTasks.queueIfPossible(BasicMachineDetails.taskForSshMachineLocation(location)).orSubmitAsync().asTask()).getUnchecked();
    }

    static Task<BasicMachineDetails> taskForSshMachineLocation(SshMachineLocation location) {
        List script;
        BufferedReader reader = new BufferedReader(Streams.reader((InputStream)new ResourceUtils(BasicMachineDetails.class).getResourceFromUrl("classpath://brooklyn/location/basic/os-details.sh")));
        try {
            script = CharStreams.readLines((Readable)reader);
        }
        catch (IOException e) {
            LOG.error("Error reading os-details script", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                LOG.error("Error closing os-details script reader", (Throwable)e);
            }
        }
        Task task = ((AbstractSshExecTaskFactory)((PlainSshExecTaskFactory)((PlainSshExecTaskFactory)new PlainSshExecTaskFactory(location, script).summary("Getting machine details for: " + location)).requiringZeroAndReturningStdout()).returning((Function)BasicMachineDetails.taskToMachineDetailsFunction(location))).newTask().asTask();
        return task;
    }

    private static Function<ProcessTaskWrapper<?>, BasicMachineDetails> taskToMachineDetailsFunction(final SshMachineLocation location) {
        return new Function<ProcessTaskWrapper<?>, BasicMachineDetails>(){

            public BasicMachineDetails apply(ProcessTaskWrapper<?> input) {
                if (input.getExitCode() != 0) {
                    LOG.warn("Non-zero exit code when fetching machine details for {}; guessing anonymous linux", (Object)location);
                    return new BasicMachineDetails(new BasicHardwareDetails(null, null), BasicOsDetails.Factory.ANONYMOUS_LINUX);
                }
                String stdout = input.getStdout();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found following details at {}: {}", (Object)location, (Object)stdout);
                }
                HashMap details = Maps.newHashMap((Map)Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)"\r\n")).omitEmptyStrings().withKeyValueSeparator(":").split((CharSequence)stdout));
                String name = (String)details.remove("name");
                String version = (String)details.remove("version");
                String architecture = (String)details.remove("architecture");
                Integer ram = this.intOrNull(details, "ram");
                Integer cpuCount = this.intOrNull(details, "cpus");
                if (!details.isEmpty()) {
                    LOG.debug("Unused keys from os-details script: " + Joiner.on((String)", ").join(details.keySet()));
                }
                BasicOsDetails osDetails = new BasicOsDetails(name, architecture, version);
                BasicHardwareDetails hardwareDetails = new BasicHardwareDetails(cpuCount, ram);
                BasicMachineDetails machineDetails = new BasicMachineDetails(hardwareDetails, osDetails);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Machine details for {}: {}", (Object)location, (Object)machineDetails);
                }
                return machineDetails;
            }

            private Integer intOrNull(Map<String, String> details, String key) {
                try {
                    return Integer.valueOf(details.remove(key));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        };
    }
}

