/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.basic;

import brooklyn.catalog.CatalogItem;
import brooklyn.catalog.CatalogPredicates;
import brooklyn.config.BrooklynProperties;
import brooklyn.config.ConfigMap;
import brooklyn.config.ConfigPredicates;
import brooklyn.config.ConfigUtils;
import brooklyn.location.Location;
import brooklyn.location.LocationDefinition;
import brooklyn.location.LocationRegistry;
import brooklyn.location.LocationResolver;
import brooklyn.location.LocationSpec;
import brooklyn.location.basic.BasicLocationDefinition;
import brooklyn.location.basic.BasicOsDetails;
import brooklyn.location.basic.LocationConfigUtils;
import brooklyn.location.basic.LocationInternal;
import brooklyn.management.ManagementContext;
import brooklyn.management.internal.LocalLocationManager;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.guava.Maybe;
import brooklyn.util.javalang.JavaClassNames;
import brooklyn.util.text.Identifiers;
import brooklyn.util.text.StringEscapes;
import brooklyn.util.text.WildcardGlobs;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicLocationRegistry
implements LocationRegistry {
    public static final Logger log = LoggerFactory.getLogger(BasicLocationRegistry.class);
    private final ManagementContext mgmt;
    private final Map<String, LocationDefinition> definedLocations = new LinkedHashMap<String, LocationDefinition>();
    protected final Map<String, LocationResolver> resolvers = new LinkedHashMap<String, LocationResolver>();
    private final Set<String> specsWarnedOnException = Sets.newConcurrentHashSet();
    protected ThreadLocal<Set<String>> specsSeen = new ThreadLocal();

    public static List<String> expandCommaSeparateLocations(String locations) {
        return WildcardGlobs.getGlobsAfterBraceExpansion((String)("{" + locations + "}"), (boolean)false, (WildcardGlobs.PhraseTreatment)WildcardGlobs.PhraseTreatment.INTERIOR_NOT_EXPANDABLE, (WildcardGlobs.PhraseTreatment)WildcardGlobs.PhraseTreatment.INTERIOR_NOT_EXPANDABLE);
    }

    public BasicLocationRegistry(ManagementContext mgmt) {
        this.mgmt = (ManagementContext)Preconditions.checkNotNull((Object)mgmt, (Object)"mgmt");
        this.findServices();
        this.updateDefinedLocations();
    }

    protected void findServices() {
        ServiceLoader<LocationResolver> loader = ServiceLoader.load(LocationResolver.class, this.mgmt.getCatalogClassLoader());
        for (LocationResolver r : loader) {
            this.registerResolver(r);
        }
        if (log.isDebugEnabled()) {
            log.debug("Location resolvers are: " + this.resolvers);
        }
        if (this.resolvers.isEmpty()) {
            log.warn("No location resolvers detected: is src/main/resources correctly included?");
        }
    }

    public boolean registerResolver(LocationResolver r) {
        r.init(this.mgmt);
        if (r instanceof LocationResolver.EnableableLocationResolver && !((LocationResolver.EnableableLocationResolver)r).isEnabled()) {
            return false;
        }
        this.resolvers.put(r.getPrefix(), r);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, LocationDefinition> getDefinedLocations() {
        Map<String, LocationDefinition> map = this.definedLocations;
        synchronized (map) {
            return ImmutableMap.copyOf(this.definedLocations);
        }
    }

    public LocationDefinition getDefinedLocationById(String id) {
        return this.definedLocations.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocationDefinition getDefinedLocationByName(String name) {
        Map<String, LocationDefinition> map = this.definedLocations;
        synchronized (map) {
            for (LocationDefinition l : this.definedLocations.values()) {
                if (!l.getName().equals(name)) continue;
                return l;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDefinedLocation(LocationDefinition l) {
        Map<String, LocationDefinition> map = this.definedLocations;
        synchronized (map) {
            this.definedLocations.put(l.getId(), l);
        }
    }

    public void updateDefinedLocation(CatalogItem<Location, LocationSpec<?>> item) {
        String id = item.getCatalogItemId();
        String symbolicName = item.getSymbolicName();
        String spec = "brooklyn.catalog:" + id;
        ImmutableMap config = ImmutableMap.of();
        BasicLocationDefinition locDefinition = new BasicLocationDefinition(symbolicName, symbolicName, spec, (Map<String, ? extends Object>)config);
        this.updateDefinedLocation(locDefinition);
    }

    public void removeDefinedLocation(CatalogItem<Location, LocationSpec<?>> item) {
        this.removeDefinedLocation(item.getSymbolicName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDefinedLocation(String id) {
        LocationDefinition removed;
        Map<String, LocationDefinition> map = this.definedLocations;
        synchronized (map) {
            removed = this.definedLocations.remove(id);
        }
        if (removed == null && log.isDebugEnabled()) {
            log.debug("{} was asked to remove location with id {} but no such location was registered", (Object)this, (Object)id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDefinedLocations() {
        Map<String, LocationDefinition> map = this.definedLocations;
        synchronized (map) {
            int count = 0;
            String NAMED_LOCATION_PREFIX = "brooklyn.location.named.";
            ConfigMap namedLocationProps = this.mgmt.getConfig().submap(ConfigPredicates.startingWith(NAMED_LOCATION_PREFIX));
            for (String k : namedLocationProps.asMapWithStringKeys().keySet()) {
                String name = k.substring(NAMED_LOCATION_PREFIX.length());
                if (name.contains(".")) continue;
                String spec = (String)namedLocationProps.asMapWithStringKeys().get(k);
                String id = Identifiers.makeRandomId((int)8);
                BrooklynProperties config = ConfigUtils.filterForPrefixAndStrip(namedLocationProps.asMapWithStringKeys(), k + ".");
                this.definedLocations.put(id, new BasicLocationDefinition(id, name, spec, config));
                ++count;
            }
            if (log.isDebugEnabled()) {
                log.debug("Found " + count + " defined locations from properties (*.named.* syntax): " + this.definedLocations.values());
            }
            if (this.getDefinedLocationByName("localhost") == null && !BasicOsDetails.Factory.newLocalhostInstance().isWindows() && LocationConfigUtils.isEnabled(this.mgmt, "brooklyn.location.localhost")) {
                log.debug("Adding a defined location for localhost");
                ImmutableMap oldDefined = ImmutableMap.copyOf(this.definedLocations);
                this.definedLocations.clear();
                String id = Identifiers.makeRandomId((int)8);
                this.definedLocations.put(id, BasicLocationRegistry.localhost(id));
                this.definedLocations.putAll((Map<String, LocationDefinition>)oldDefined);
            }
            for (CatalogItem item : this.mgmt.getCatalog().getCatalogItems(CatalogPredicates.IS_LOCATION)) {
                this.updateDefinedLocation(item);
                ++count;
            }
        }
    }

    @VisibleForTesting
    void disablePersistence() {
    }

    protected static BasicLocationDefinition localhost(String id) {
        return new BasicLocationDefinition(id, "localhost", "localhost", null);
    }

    @Deprecated
    public boolean canMaybeResolve(String spec) {
        return this.getSpecResolver(spec) != null;
    }

    public final Location resolve(String spec) {
        return (Location)this.resolve(spec, (Boolean)true, null).get();
    }

    @Deprecated
    public final Location resolveIfPossible(String spec) {
        if (!this.canMaybeResolve(spec)) {
            return null;
        }
        return (Location)this.resolve(spec, null, null).orNull();
    }

    @Deprecated
    public final Maybe<Location> resolve(String spec, boolean manage) {
        return this.resolve(spec, (Boolean)manage, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Maybe<Location> resolve(String spec, Boolean manage, Map locationFlags) {
        try {
            String errmsg;
            Set<String> seenSoFar;
            locationFlags = MutableMap.copyOf((Map)locationFlags);
            if (manage != null) {
                locationFlags.put(LocalLocationManager.CREATE_UNMANAGED, manage == false);
            }
            if ((seenSoFar = this.specsSeen.get()) == null) {
                seenSoFar = new LinkedHashSet<String>();
                this.specsSeen.set(seenSoFar);
            }
            if (seenSoFar.contains(spec)) {
                Maybe maybe = Maybe.absent((Supplier)Suppliers.ofInstance((Object)new IllegalStateException("Circular reference in definition of location '" + spec + "' (" + seenSoFar + ")")));
                return maybe;
            }
            seenSoFar.add(spec);
            LocationResolver resolver = this.getSpecResolver(spec);
            if (resolver != null) {
                try {
                    Maybe maybe = Maybe.of((Object)resolver.newLocationFromString(locationFlags, spec, (LocationRegistry)this));
                    return maybe;
                }
                catch (RuntimeException e) {
                    Maybe maybe = Maybe.absent((Supplier)Suppliers.ofInstance((Object)e));
                    this.specsSeen.remove();
                    return maybe;
                }
            }
            if (spec == null || this.specsWarnedOnException.add(spec)) {
                if (this.resolvers.get("id") == null || this.resolvers.get("named") == null) {
                    log.error("Standard location resolvers not installed, location resolution will fail shortly. This usually indicates a classpath problem, such as when running from an IDE which has not properly copied META-INF/services from src/main/resources. Known resolvers are: " + this.resolvers.keySet());
                    errmsg = "Unresolvable location '" + spec + "': " + "Problem detected with location resolver configuration; " + this.resolvers.keySet() + " are the only available location resolvers. " + "More information can be found in the logs.";
                } else {
                    log.warn("Location resolution failed for '" + spec + "' (will fail shortly): known resolvers are: " + this.resolvers.keySet());
                    errmsg = "Unknown location '" + spec + "': " + "either this location is not recognised or there is a problem with location resolver configuration.";
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Location resolution failed again for '" + spec + "' (throwing)");
                }
                errmsg = "Unknown location '" + spec + "': " + "either this location is not recognised or there is a problem with location resolver configuration.";
            }
            Maybe maybe = Maybe.absent((Supplier)Suppliers.ofInstance((Object)new NoSuchElementException(errmsg)));
            return maybe;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.specsSeen.remove();
        }
    }

    public final Location resolve(String spec, Map locationFlags) {
        return (Location)this.resolve(spec, null, locationFlags).get();
    }

    protected LocationResolver getSpecResolver(String spec) {
        int colonIndex = spec.indexOf(58);
        int bracketIndex = spec.indexOf("(");
        int dividerIndex = colonIndex < 0 ? bracketIndex : (bracketIndex < 0 ? colonIndex : Math.min(bracketIndex, colonIndex));
        String prefix = dividerIndex >= 0 ? spec.substring(0, dividerIndex) : spec;
        LocationResolver resolver = this.resolvers.get(prefix);
        if (resolver == null) {
            resolver = this.getSpecDefaultResolver(spec);
        }
        return resolver;
    }

    protected LocationResolver getSpecDefaultResolver(String spec) {
        return this.getSpecFirstResolver(spec, "id", "named", "jclouds");
    }

    protected LocationResolver getSpecFirstResolver(String spec, String ... resolversToCheck) {
        for (String resolverId : resolversToCheck) {
            LocationResolver resolver = this.resolvers.get(resolverId);
            if (resolver == null || !resolver.accepts(spec, (LocationRegistry)this)) continue;
            return resolver;
        }
        return null;
    }

    public static boolean isResolverPrefixForSpec(LocationResolver resolver, String spec, boolean argumentRequired) {
        if (spec == null) {
            return false;
        }
        if (spec.startsWith(resolver.getPrefix() + ":")) {
            return true;
        }
        return !argumentRequired && spec.equals(resolver.getPrefix());
    }

    public List<Location> resolve(Iterable<?> spec) {
        ArrayList<Location> result = new ArrayList<Location>();
        for (Object id : spec) {
            if (id instanceof String) {
                result.add(this.resolve((String)id));
                continue;
            }
            if (id instanceof Location) {
                result.add((Location)id);
                continue;
            }
            if (id instanceof Iterable) {
                throw new IllegalArgumentException("Cannot resolve '" + id + "' to a location; collections of collections not allowed");
            }
            throw new IllegalArgumentException("Cannot resolve '" + id + "' to a location; unsupported type " + (id == null ? "null" : id.getClass().getName()));
        }
        return result;
    }

    public List<Location> resolveList(Object l) {
        if (l == null) {
            l = Collections.emptyList();
        }
        if (l instanceof String) {
            l = StringEscapes.JavaStringEscapes.unwrapJsonishListIfPossible((String)((String)((Object)l)));
        }
        if (l instanceof Iterable) {
            return this.resolve(l);
        }
        throw new IllegalArgumentException("Location list must be supplied as a collection or a string, not " + JavaClassNames.simpleClassName((Object)l) + "/" + l);
    }

    public Location resolve(LocationDefinition ld) {
        return (Location)this.resolve(ld, null, null).get();
    }

    @Deprecated
    public Location resolveForPeeking(LocationDefinition ld) {
        return this.resolve(ld, ConfigBag.newInstance().configure(LocalLocationManager.CREATE_UNMANAGED, true).getAllConfig());
    }

    @Deprecated
    public Location resolve(LocationDefinition ld, Map<?, ?> flags) {
        return this.resolveLocationDefinition(ld, flags, null);
    }

    @Deprecated
    public Location resolveLocationDefinition(LocationDefinition ld, Map locationFlags, String optionalName) {
        return (Location)this.resolve(ld, null, locationFlags).get();
    }

    public Maybe<Location> resolve(LocationDefinition ld, Boolean manage, Map locationFlags) {
        ConfigBag newLocationFlags = ConfigBag.newInstance(ld.getConfig()).putAll(locationFlags).putIfAbsentAndNotNull(LocationInternal.NAMED_SPEC_NAME, ld.getName()).putIfAbsentAndNotNull(LocationInternal.ORIGINAL_SPEC, ld.getName());
        Maybe<Location> result = this.resolve(ld.getSpec(), manage, newLocationFlags.getAllConfigRaw());
        if (result.isPresent()) {
            return result;
        }
        throw new IllegalStateException("Cannot instantiate location '" + ld + "' pointing at " + ld.getSpec() + ": " + Exceptions.collapseText((Throwable)((Maybe.Absent)result).getException()));
    }

    public Map getProperties() {
        return this.mgmt.getConfig().asMapWithStringKeys();
    }

    @VisibleForTesting
    public static void setupLocationRegistryForTesting(ManagementContext mgmt) {
        LocationDefinition l = mgmt.getLocationRegistry().getDefinedLocationByName("localhost");
        if (l == null) {
            mgmt.getLocationRegistry().updateDefinedLocation((LocationDefinition)BasicLocationRegistry.localhost(Identifiers.makeRandomId((int)8)));
        }
        ((BasicLocationRegistry)mgmt.getLocationRegistry()).disablePersistence();
    }
}

