/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.basic;

import brooklyn.location.LocationDefinition;
import brooklyn.util.text.Identifiers;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class BasicLocationDefinition
implements LocationDefinition {
    private final String id;
    private final String name;
    private final String spec;
    private final Map<String, Object> config;

    public BasicLocationDefinition(String name, String spec, Map<String, ? extends Object> config) {
        this(Identifiers.makeRandomId((int)8), name, spec, config);
    }

    public BasicLocationDefinition(String id, String name, String spec, Map<String, ? extends Object> config) {
        this.id = (String)Preconditions.checkNotNull((Object)id);
        this.name = name;
        this.spec = (String)Preconditions.checkNotNull((Object)spec);
        this.config = config == null ? ImmutableMap.of() : ImmutableMap.copyOf(config);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getSpec() {
        return this.spec;
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof LocationDefinition && this.id.equals(((LocationDefinition)o).getId());
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "LocationDefinition{id='" + this.getId() + '\'' + ", name='" + this.getName() + '\'' + ", spec='" + this.getSpec() + '\'' + ", config=" + this.getConfig() + '}';
    }
}

