/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.basic;

import brooklyn.location.MachineLocation;
import brooklyn.location.MachineProvisioningLocation;
import brooklyn.location.NoMachinesAvailableException;
import brooklyn.location.basic.AbstractLocation;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.stream.Streams;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class AggregatingMachineProvisioningLocation<T extends MachineLocation>
extends AbstractLocation
implements MachineProvisioningLocation<T>,
Closeable {
    private Object lock;
    @SetFromFlag
    protected List<MachineProvisioningLocation<T>> provisioners;
    @SetFromFlag
    protected Map<T, MachineProvisioningLocation<T>> inUse;
    protected final AtomicInteger obtainCounter = new AtomicInteger();

    public AggregatingMachineProvisioningLocation() {
        this((Map)Maps.newLinkedHashMap());
    }

    public AggregatingMachineProvisioningLocation(Map properties) {
        super(properties);
        if (this.isLegacyConstruction()) {
            this.init();
        }
    }

    @Override
    public void init() {
        super.init();
    }

    @Override
    public String toVerboseString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.getId()).add("name", (Object)this.getDisplayName()).add("provisioners", this.provisioners).toString();
    }

    @Override
    public AbstractLocation configure(Map<?, ?> properties) {
        if (this.lock == null) {
            this.lock = new Object();
            this.provisioners = Lists.newArrayList();
            this.inUse = Maps.newLinkedHashMap();
        }
        return super.configure((Map)properties);
    }

    public AggregatingMachineProvisioningLocation<T> newSubLocation(Map<?, ?> newFlags) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        for (MachineProvisioningLocation<T> provisioner : this.provisioners) {
            if (!(provisioner instanceof Closeable)) continue;
            Streams.closeQuietly((Closeable)((Closeable)provisioner));
        }
    }

    public T obtain() throws NoMachinesAvailableException {
        return this.obtain(Maps.newLinkedHashMap());
    }

    public T obtain(Map<?, ?> flags) throws NoMachinesAvailableException {
        Preconditions.checkState((this.provisioners.size() > 0 ? 1 : 0) != 0, (Object)"no provisioners!");
        int index = this.obtainCounter.getAndIncrement();
        for (int i = 0; i < this.provisioners.size(); ++i) {
            MachineProvisioningLocation<T> provisioner = this.provisioners.get(index++ % this.provisioners.size());
            try {
                MachineLocation machine = provisioner.obtain(flags);
                this.inUse.put(machine, provisioner);
                return (T)machine;
            }
            catch (NoMachinesAvailableException e) {
                continue;
            }
        }
        throw new NoMachinesAvailableException("No machines available in " + this.toString());
    }

    public void release(T machine) {
        MachineProvisioningLocation<T> provisioner = this.inUse.remove(machine);
        if (provisioner == null) {
            throw new IllegalStateException("Request to release machine " + machine + ", but this machine is not currently allocated");
        }
        provisioner.release(machine);
    }

    public Map<String, Object> getProvisioningFlags(Collection<String> tags) {
        return Maps.newLinkedHashMap();
    }
}

