/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.basic;

import brooklyn.basic.AbstractBrooklynObject;
import brooklyn.basic.BrooklynObject;
import brooklyn.basic.BrooklynObjectInternal;
import brooklyn.config.ConfigInheritance;
import brooklyn.config.ConfigKey;
import brooklyn.entity.rebind.BasicLocationRebindSupport;
import brooklyn.entity.rebind.RebindSupport;
import brooklyn.entity.trait.Configurable;
import brooklyn.event.basic.BasicConfigKey;
import brooklyn.internal.BrooklynFeatureEnablement;
import brooklyn.internal.storage.BrooklynStorage;
import brooklyn.internal.storage.Reference;
import brooklyn.internal.storage.impl.BasicReference;
import brooklyn.location.Location;
import brooklyn.location.LocationSpec;
import brooklyn.location.basic.LocationConfigKeys;
import brooklyn.location.basic.LocationDynamicType;
import brooklyn.location.basic.LocationInternal;
import brooklyn.location.basic.Locations;
import brooklyn.location.geo.HasHostGeoInfo;
import brooklyn.location.geo.HostGeoInfo;
import brooklyn.management.Task;
import brooklyn.management.internal.LocalLocationManager;
import brooklyn.management.internal.ManagementContextInternal;
import brooklyn.mementos.LocationMemento;
import brooklyn.util.GroovyJavaMethods;
import brooklyn.util.JavaGroovyEquivalents;
import brooklyn.util.collections.SetFromLiveMap;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.flags.FlagUtils;
import brooklyn.util.flags.TypeCoercions;
import brooklyn.util.guava.Maybe;
import brooklyn.util.stream.Streams;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import java.io.Closeable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLocation
extends AbstractBrooklynObject
implements LocationInternal,
HasHostGeoInfo,
Configurable {
    private static final long serialVersionUID = -7495805474138619830L;
    @Deprecated
    public static final Logger LOG = LoggerFactory.getLogger(AbstractLocation.class);
    public static final ConfigKey<Location> PARENT_LOCATION = new BasicConfigKey<Location>(Location.class, "parentLocation");
    private final AtomicBoolean configured = new AtomicBoolean();
    private Reference<Long> creationTimeUtc = new BasicReference<Long>(System.currentTimeMillis());
    private Reference<Location> parent = new BasicReference<Location>();
    private Set<Location> children = Sets.newLinkedHashSet();
    private Reference<String> name = new BasicReference<String>();
    private boolean displayNameAutoGenerated = true;
    private Reference<HostGeoInfo> hostGeoInfo = new BasicReference<HostGeoInfo>();
    private BasicConfigurationSupport config = new BasicConfigurationSupport();
    private ConfigBag configBag = new ConfigBag();
    private volatile boolean managed;
    private boolean inConstruction = true;
    private Reference<Map<Class<?>, Object>> extensions = new BasicReference<ConcurrentMap>(Maps.newConcurrentMap());
    private final LocationDynamicType locationType = new LocationDynamicType(this);

    public AbstractLocation() {
        this(Maps.newLinkedHashMap());
    }

    public AbstractLocation(Map<?, ?> properties) {
        super(properties);
        if (this.isLegacyConstruction()) {
            boolean deferConstructionChecks;
            AbstractBrooklynObject checkWeGetThis = this.configure((Map)properties);
            assert (this.equals(checkWeGetThis)) : this + " configure method does not return itself; returns " + checkWeGetThis + " instead of " + this;
            boolean bl = deferConstructionChecks = properties.containsKey("deferConstructionChecks") && TypeCoercions.coerce(properties.get("deferConstructionChecks"), Boolean.class) != false;
            if (!deferConstructionChecks) {
                FlagUtils.checkRequiredFields(this);
            }
        }
        this.inConstruction = false;
    }

    protected void assertNotYetManaged() {
        if (!this.inConstruction && Locations.isManaged(this)) {
            LOG.warn("Configuration being made to {} after deployment; may not be supported in future versions", (Object)this);
        }
    }

    @Override
    public void setManagementContext(ManagementContextInternal managementContext) {
        super.setManagementContext(managementContext);
        if (this.displayNameAutoGenerated && this.getId() != null) {
            this.name.set(this.getClass().getSimpleName() + ":" + this.getId().substring(0, Math.min(this.getId().length(), 4)));
        }
        if (BrooklynFeatureEnablement.isEnabled("brooklyn.experimental.feature.useBrooklynLiveObjectsDatagridStorage")) {
            Location oldParent = this.parent.get();
            Set<Location> oldChildren = this.children;
            Map<String, Object> oldConfig = this.configBag.getAllConfig();
            Long oldCreationTimeUtc = this.creationTimeUtc.get();
            String oldDisplayName = this.name.get();
            HostGeoInfo oldHostGeoInfo = this.hostGeoInfo.get();
            this.parent = managementContext.getStorage().getReference(this.getId() + "-parent");
            this.children = SetFromLiveMap.create(managementContext.getStorage().getMap(this.getId() + "-children"));
            this.creationTimeUtc = managementContext.getStorage().getReference(this.getId() + "-creationTime");
            this.hostGeoInfo = managementContext.getStorage().getReference(this.getId() + "-hostGeoInfo");
            this.name = managementContext.getStorage().getReference(this.getId() + "-displayName");
            if (oldParent != null) {
                this.parent.set(oldParent);
            }
            if (oldChildren.size() > 0) {
                this.children.addAll(oldChildren);
            }
            if (this.creationTimeUtc.isNull()) {
                this.creationTimeUtc.set(oldCreationTimeUtc);
            }
            if (this.hostGeoInfo.isNull()) {
                this.hostGeoInfo.set(oldHostGeoInfo);
            }
            if (this.name.isNull()) {
                this.name.set(oldDisplayName);
            } else {
                this.displayNameAutoGenerated = false;
            }
            this.configBag = ConfigBag.newLiveInstance(managementContext.getStorage().getMap(this.getId() + "-config"));
            if (oldConfig.size() > 0) {
                this.configBag.putAll(oldConfig);
            }
        }
    }

    @Override
    @Deprecated
    public AbstractLocation configure(Map<?, ?> properties) {
        this.assertNotYetManaged();
        boolean firstTime = !this.configured.getAndSet(true);
        this.configBag.putAll(properties);
        if (properties.containsKey(PARENT_LOCATION.getName())) {
            this.setParent(this.configBag.get(PARENT_LOCATION));
            this.configBag.remove(PARENT_LOCATION);
        }
        FlagUtils.setFieldsFromFlagsWithBag(this, properties, this.configBag, firstTime);
        FlagUtils.setAllConfigKeys(this, this.configBag, false);
        if (properties.containsKey("displayName")) {
            this.name.set((String)AbstractLocation.removeIfPossible(properties, "displayName"));
            this.displayNameAutoGenerated = false;
        } else if (properties.containsKey("name")) {
            this.name.set((String)AbstractLocation.removeIfPossible(properties, "name"));
            this.displayNameAutoGenerated = false;
        } else if (this.isLegacyConstruction()) {
            this.name.set(this.getClass().getSimpleName() + ":" + this.getId().substring(0, Math.min(this.getId().length(), 4)));
            this.displayNameAutoGenerated = true;
        }
        if (JavaGroovyEquivalents.groovyTruth(properties.get("iso3166"))) {
            Object rawCodes = AbstractLocation.removeIfPossible(properties, "iso3166");
            Object codes = rawCodes instanceof CharSequence ? ImmutableSet.copyOf((Iterable)Splitter.on((String)",").trimResults().split((CharSequence)rawCodes)) : TypeCoercions.coerce(rawCodes, new TypeToken<Set<String>>(){});
            this.configBag.put(LocationConfigKeys.ISO_3166, codes);
        }
        return this;
    }

    private static Object removeIfPossible(Map<?, ?> map, Object key) {
        try {
            return map.remove(key);
        }
        catch (Exception e) {
            return map.get(key);
        }
    }

    public boolean isManaged() {
        return this.getManagementContext() != null && this.managed;
    }

    public void onManagementStarted() {
        if (this.displayNameAutoGenerated) {
            this.name.set(this.getClass().getSimpleName() + ":" + this.getId().substring(0, Math.min(this.getId().length(), 4)));
        }
        this.managed = true;
    }

    public void onManagementStopped() {
        this.managed = false;
        if (this.getManagementContext().isRunning()) {
            BrooklynStorage storage = ((ManagementContextInternal)this.getManagementContext()).getStorage();
            storage.remove(this.getId() + "-parent");
            storage.remove(this.getId() + "-children");
            storage.remove(this.getId() + "-creationTime");
            storage.remove(this.getId() + "-hostGeoInfo");
            storage.remove(this.getId() + "-displayName");
            storage.remove(this.getId() + "-config");
        }
    }

    public String getDisplayName() {
        return this.name.get();
    }

    protected boolean isDisplayNameAutoGenerated() {
        return this.displayNameAutoGenerated;
    }

    public Location getParent() {
        return this.parent.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Location> getChildren() {
        Set<Location> set = this.children;
        synchronized (set) {
            return ImmutableList.copyOf(this.children);
        }
    }

    public void setParent(Location newParent) {
        this.setParent(newParent, true);
    }

    public void setParent(Location newParent, boolean updateChildListParents) {
        if (newParent == this) {
            throw new IllegalArgumentException("Location cannot be its own parent: " + this);
        }
        if (newParent == this.parent.get()) {
            return;
        }
        if (this.parent.get() != null) {
            Location oldParent = this.parent.get();
            this.parent.set(null);
            if (updateChildListParents) {
                ((AbstractLocation)oldParent).removeChild(this);
            }
        }
        this.parent.set(newParent);
        if (newParent != null && updateChildListParents) {
            ((AbstractLocation)newParent).addChild(this);
        }
        this.onChanged();
    }

    @Override
    public BrooklynObjectInternal.ConfigurationSupportInternal config() {
        return this.config;
    }

    public <T> T getConfig(ConfigKey.HasConfigKey<T> key) {
        return (T)this.config().get(key);
    }

    public <T> T getConfig(ConfigKey<T> key) {
        return (T)this.config().get(key);
    }

    @Deprecated
    public boolean hasConfig(ConfigKey<?> key, boolean includeInherited) {
        return this.config.hasConfig(key, includeInherited);
    }

    @Deprecated
    public Map<String, Object> getAllConfig(boolean includeInherited) {
        ConfigBag bag = includeInherited ? this.config().getBag() : this.config().getLocalBag();
        return bag.getAllConfig();
    }

    @Override
    @Deprecated
    public ConfigBag getAllConfigBag() {
        return this.config().getBag();
    }

    @Override
    public ConfigBag getLocalConfigBag() {
        return this.config().getLocalBag();
    }

    @Deprecated
    public ConfigBag getRawLocalConfigBag() {
        return this.config().getLocalBag();
    }

    @Deprecated
    public <T> T setConfig(ConfigKey<T> key, T value) {
        return (T)this.config().set(key, value);
    }

    @Deprecated
    public void setName(String newName) {
        this.setDisplayName(newName);
    }

    @Override
    public void setDisplayName(String newName) {
        this.name.set(newName);
        this.displayNameAutoGenerated = false;
        this.onChanged();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Location)) {
            return false;
        }
        Location l = (Location)o;
        return this.getId().equals(l.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean containsLocation(Location potentialDescendent) {
        for (Location loc = potentialDescendent; loc != null; loc = loc.getParent()) {
            if (this != loc) continue;
            return true;
        }
        return false;
    }

    protected <T extends Location> T addChild(LocationSpec<T> spec) {
        Location child = this.getManagementContext().getLocationManager().createLocation(spec);
        this.addChild(child);
        return (T)child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(Location child) {
        Set<Location> set = this.children;
        synchronized (set) {
            for (Location contender : this.children) {
                if (contender != child) continue;
                return;
            }
            this.children.add(child);
        }
        if (this.isManaged()) {
            if (!this.getManagementContext().getLocationManager().isManaged(child)) {
                Locations.manage(child, this.getManagementContext());
            }
        } else if (this.getManagementContext() != null && ((LocalLocationManager)this.getManagementContext().getLocationManager()).getLocationEvenIfPreManaged(child.getId()) == null) {
            ((ManagementContextInternal)this.getManagementContext()).prePreManage(child);
        }
        this.children.add(child);
        child.setParent((Location)this);
        this.onChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeChild(Location child) {
        boolean removed;
        Set<Location> set = this.children;
        synchronized (set) {
            removed = this.children.remove(child);
        }
        if (removed) {
            if (child instanceof Closeable) {
                Streams.closeQuietly((Closeable)((Closeable)child));
            }
            child.setParent(null);
            if (this.isManaged()) {
                this.getManagementContext().getLocationManager().unmanage(child);
            }
        }
        this.onChanged();
        return removed;
    }

    protected void onChanged() {
        if (this.isManaged()) {
            this.getManagementContext().getRebindManager().getChangeListener().onChanged((BrooklynObject)this);
        }
    }

    public String toString() {
        return this.string().toString();
    }

    public String toVerboseString() {
        return this.toString();
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this.getClass()).add("id", (Object)this.getId()).add("name", this.name);
    }

    @Override
    public HostGeoInfo getHostGeoInfo() {
        return this.hostGeoInfo.get();
    }

    public void setHostGeoInfo(HostGeoInfo hostGeoInfo) {
        if (hostGeoInfo != null) {
            this.hostGeoInfo.set(hostGeoInfo);
            this.setConfig(LocationConfigKeys.LATITUDE, hostGeoInfo.latitude);
            this.setConfig(LocationConfigKeys.LONGITUDE, hostGeoInfo.longitude);
        }
    }

    @Override
    public RebindSupport<LocationMemento> getRebindSupport() {
        return new BasicLocationRebindSupport(this);
    }

    public boolean hasExtension(Class<?> extensionType) {
        return this.extensions.get().containsKey(Preconditions.checkNotNull(extensionType, (Object)"extensionType"));
    }

    public <T> T getExtension(Class<T> extensionType) {
        Object extension = this.extensions.get().get(Preconditions.checkNotNull(extensionType, (Object)"extensionType"));
        if (extension == null) {
            throw new IllegalArgumentException("No extension of type " + extensionType + " registered for location " + this);
        }
        return (T)extension;
    }

    @Override
    public <T> void addExtension(Class<T> extensionType, T extension) {
        Preconditions.checkNotNull(extensionType, (Object)"extensionType");
        Preconditions.checkNotNull(extension, (Object)"extension");
        Preconditions.checkArgument((boolean)extensionType.isInstance(extension), (String)"extension %s does not implement %s", (Object[])new Object[]{extension, extensionType});
        this.extensions.get().put(extensionType, extension);
    }

    @Override
    public Map<String, String> toMetadataRecord() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (this.getDisplayName() != null) {
            builder.put((Object)"displayName", (Object)this.getDisplayName());
        }
        if (this.getParent() != null && this.getParent().getDisplayName() != null) {
            builder.put((Object)"parentDisplayName", (Object)this.getParent().getDisplayName());
        }
        return builder.build();
    }

    private class BasicConfigurationSupport
    implements BrooklynObjectInternal.ConfigurationSupportInternal {
        private BasicConfigurationSupport() {
        }

        public <T> T get(ConfigKey<T> key) {
            if (this.hasConfig(key, false)) {
                return this.getLocalBag().get(key);
            }
            if (AbstractLocation.this.getParent() != null && this.isInherited(key)) {
                return (T)AbstractLocation.this.getParent().getConfig(key);
            }
            ConfigKey ownKey = (ConfigKey)GroovyJavaMethods.elvis(AbstractLocation.this.locationType.getConfigKey(key.getName()), key);
            return (T)ownKey.getDefaultValue();
        }

        public <T> T get(ConfigKey.HasConfigKey<T> key) {
            return this.get(key.getConfigKey());
        }

        public <T> T set(ConfigKey<T> key, T val) {
            T result = AbstractLocation.this.configBag.put(key, val);
            AbstractLocation.this.onChanged();
            return result;
        }

        public <T> T set(ConfigKey.HasConfigKey<T> key, T val) {
            return this.set(key.getConfigKey(), val);
        }

        public <T> T set(ConfigKey<T> key, Task<T> val) {
            throw new UnsupportedOperationException();
        }

        public <T> T set(ConfigKey.HasConfigKey<T> key, Task<T> val) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ConfigBag getBag() {
            ConfigBag result = ConfigBag.newInstanceExtending(AbstractLocation.this.configBag, ImmutableMap.of());
            Location p = AbstractLocation.this.getParent();
            if (p != null) {
                result.putIfAbsent(((LocationInternal)p).config().getBag());
            }
            return result;
        }

        @Override
        public ConfigBag getLocalBag() {
            return AbstractLocation.this.configBag;
        }

        @Override
        public Maybe<Object> getRaw(ConfigKey<?> key) {
            if (this.hasConfig(key, false)) {
                return Maybe.of((Object)this.getLocalBag().getStringKey(key.getName()));
            }
            if (AbstractLocation.this.getParent() != null && this.isInherited(key)) {
                return ((LocationInternal)AbstractLocation.this.getParent()).config().getRaw(key);
            }
            return Maybe.absent();
        }

        @Override
        public Maybe<Object> getRaw(ConfigKey.HasConfigKey<?> key) {
            return this.getRaw(key.getConfigKey());
        }

        @Override
        public Maybe<Object> getLocalRaw(ConfigKey<?> key) {
            if (this.hasConfig(key, false)) {
                return Maybe.of((Object)this.getLocalBag().getStringKey(key.getName()));
            }
            return Maybe.absent();
        }

        @Override
        public Maybe<Object> getLocalRaw(ConfigKey.HasConfigKey<?> key) {
            return this.getLocalRaw(key.getConfigKey());
        }

        @Override
        public void addToLocalBag(Map<String, ?> vals) {
            AbstractLocation.this.configBag.putAll(vals);
        }

        @Override
        public void refreshInheritedConfig() {
        }

        @Override
        public void refreshInheritedConfigOfChildren() {
        }

        private boolean hasConfig(ConfigKey<?> key, boolean includeInherited) {
            if (includeInherited && this.isInherited(key)) {
                return this.getBag().containsKey(key);
            }
            return this.getLocalBag().containsKey(key);
        }

        private boolean isInherited(ConfigKey<?> key) {
            ConfigInheritance inheritance = key.getInheritance();
            if (inheritance == null) {
                inheritance = this.getDefaultInheritance();
            }
            return inheritance.isInherited(key, (Object)AbstractLocation.this.getParent(), (Object)AbstractLocation.this);
        }

        private ConfigInheritance getDefaultInheritance() {
            return ConfigInheritance.ALWAYS;
        }
    }
}

