/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.access;

import brooklyn.location.Location;
import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import javax.annotation.Nullable;

public class PortMapping {
    final String publicIpId;
    final HostAndPort publicEndpoint;
    final int publicPort;
    final Location target;
    final int privatePort;

    public PortMapping(String publicIpId, HostAndPort publicEndpoint, Location target, int privatePort) {
        this.publicIpId = (String)Preconditions.checkNotNull((Object)publicIpId, (Object)"publicIpId");
        this.publicEndpoint = (HostAndPort)Preconditions.checkNotNull((Object)publicEndpoint, (Object)"publicEndpoint");
        this.publicPort = publicEndpoint.getPort();
        this.target = target;
        this.privatePort = privatePort;
    }

    public PortMapping(String publicIpId, int publicPort, Location target, int privatePort) {
        this.publicIpId = (String)Preconditions.checkNotNull((Object)publicIpId, (Object)"publicIpId");
        this.publicEndpoint = null;
        this.publicPort = publicPort;
        this.target = target;
        this.privatePort = privatePort;
    }

    @Nullable
    @Beta
    public HostAndPort getPublicEndpoint() {
        return this.publicEndpoint;
    }

    public int getPublicPort() {
        return this.publicPort;
    }

    public Location getTarget() {
        return this.target;
    }

    public int getPrivatePort() {
        return this.privatePort;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("publicIpId", (Object)(this.publicIpId + ":" + this.publicPort)).add("publicEndpoint", (Object)(this.publicEndpoint == null ? Integer.valueOf(this.publicPort) : this.publicEndpoint)).add("targetLocation", (Object)this.target).add("targetPort", this.privatePort).toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PortMapping)) {
            return false;
        }
        PortMapping opm = (PortMapping)obj;
        return Objects.equal((Object)this.publicIpId, (Object)opm.publicIpId) && Objects.equal((Object)this.publicPort, (Object)opm.publicPort) && Objects.equal((Object)this.target, (Object)opm.target) && Objects.equal((Object)this.privatePort, (Object)opm.privatePort);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.publicIpId, this.publicPort, this.target, this.privatePort});
    }
}

