/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.access;

import brooklyn.location.Location;
import brooklyn.location.LocationRegistry;
import brooklyn.location.LocationSpec;
import brooklyn.location.access.PortForwardManager;
import brooklyn.location.access.PortForwardManagerImpl;
import brooklyn.location.basic.AbstractLocationResolver;
import brooklyn.location.basic.LocationConfigUtils;
import brooklyn.location.basic.LocationInternal;
import brooklyn.location.basic.LocationPredicates;
import brooklyn.util.config.ConfigBag;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortForwardManagerLocationResolver
extends AbstractLocationResolver {
    private static final Logger LOG = LoggerFactory.getLogger(PortForwardManagerLocationResolver.class);
    public static final String PREFIX = "portForwardManager";

    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public Location newLocationFromString(Map locationFlags, String spec, LocationRegistry registry) {
        ConfigBag config = this.extractConfig(locationFlags, spec, registry);
        Map globalProperties = registry.getProperties();
        String namedLocation = (String)locationFlags.get(LocationInternal.NAMED_SPEC_NAME.getName());
        String scope = config.get(PortForwardManager.SCOPE);
        Optional result = Iterables.tryFind((Iterable)this.managementContext.getLocationManager().getLocations(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(PortForwardManager.class), LocationPredicates.configEqualTo(PortForwardManager.SCOPE, scope)));
        if (result.isPresent()) {
            return (Location)result.get();
        }
        PortForwardManager loc = (PortForwardManager)this.managementContext.getLocationManager().createLocation(LocationSpec.create(PortForwardManagerImpl.class).configure(config.getAllConfig()).configure(LocationConfigUtils.finalAndOriginalSpecs(spec, locationFlags, globalProperties, namedLocation)));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created " + loc + " for scope " + scope);
        }
        return loc;
    }

    @Override
    protected Class<? extends Location> getLocationType() {
        return PortForwardManager.class;
    }

    @Override
    protected AbstractLocationResolver.SpecParser getSpecParser() {
        return new AbstractLocationResolver.SpecParser(this.getPrefix()).setExampleUsage("\"portForwardManager\" or \"portForwardManager(scope=global)\"");
    }

    @Override
    protected ConfigBag extractConfig(Map<?, ?> locationFlags, String spec, LocationRegistry registry) {
        ConfigBag config = super.extractConfig(locationFlags, spec, registry);
        config.putAsStringKeyIfAbsent("name", "localhost");
        return config;
    }
}

