/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.access;

import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.location.Location;
import brooklyn.location.access.PortMapping;
import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.net.HostAndPort;
import java.util.Collection;

@Beta
public interface PortForwardManager
extends Location {
    public static final ConfigKey<String> SCOPE = ConfigKeys.newStringConfigKey("scope", "The scope that this applies to, defaulting to global", "global");
    @Beta
    public static final ConfigKey<Integer> PORT_FORWARD_MANAGER_STARTING_PORT = ConfigKeys.newIntegerConfigKey("brooklyn.portForwardManager.startingPort", "The starting port for assigning port numbers, such as for DNAT", 11000);

    public String getScope();

    public int acquirePublicPort(String var1);

    public void associate(String var1, HostAndPort var2, Location var3, int var4);

    public void associate(String var1, HostAndPort var2, int var3);

    @Beta
    public void addAssociationListener(AssociationListener var1, Predicate<? super AssociationMetadata> var2);

    @Beta
    public void removeAssociationListener(AssociationListener var1);

    public HostAndPort lookup(Location var1, int var2);

    public HostAndPort lookup(String var1, int var2);

    public boolean forgetPortMapping(String var1, int var2);

    public boolean forgetPortMappings(Location var1);

    public boolean forgetPortMappings(String var1);

    public String toVerboseString();

    @Deprecated
    public int acquirePublicPort(String var1, Location var2, int var3);

    @Deprecated
    public PortMapping acquirePublicPortExplicit(String var1, int var2);

    @Deprecated
    public void associate(String var1, int var2, Location var3, int var4);

    @Deprecated
    public void recordPublicIpHostname(String var1, String var2);

    @Deprecated
    public String getPublicIpHostname(String var1);

    @Deprecated
    public boolean forgetPublicIpHostname(String var1);

    @Deprecated
    public boolean isClient();

    @Deprecated
    public PortMapping getPortMappingWithPublicSide(String var1, int var2);

    @Deprecated
    public Collection<PortMapping> getPortMappingWithPublicIpId(String var1);

    @Deprecated
    public boolean forgetPortMapping(PortMapping var1);

    @Deprecated
    public HostAndPort getPublicHostAndPort(PortMapping var1);

    @Deprecated
    public Collection<PortMapping> getLocationPublicIpIds(Location var1);

    @Deprecated
    public PortMapping getPortMappingWithPrivateSide(Location var1, int var2);

    @Beta
    public static interface AssociationListener {
        public void onAssociationCreated(AssociationMetadata var1);

        public void onAssociationDeleted(AssociationMetadata var1);
    }

    @Beta
    public static class AssociationMetadata {
        private final String publicIpId;
        private final HostAndPort publicEndpoint;
        private final Location location;
        private final int privatePort;

        public AssociationMetadata(String publicIpId, HostAndPort publicEndpoint, Location location, int privatePort) {
            this.publicIpId = publicIpId;
            this.publicEndpoint = publicEndpoint;
            this.location = location;
            this.privatePort = privatePort;
        }

        public String getPublicIpId() {
            return this.publicIpId;
        }

        public HostAndPort getPublicEndpoint() {
            return this.publicEndpoint;
        }

        public Location getLocation() {
            return this.location;
        }

        public int getPrivatePort() {
            return this.privatePort;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("publicIpId", (Object)this.publicIpId).add("publicEndpoint", (Object)this.publicEndpoint).add("location", (Object)this.location).add("privatePort", this.privatePort).toString();
        }
    }
}

