/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.access;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.Attributes;
import brooklyn.event.basic.BasicConfigKey;
import brooklyn.location.Location;
import brooklyn.location.MachineLocation;
import brooklyn.location.access.PortForwardManager;
import brooklyn.location.basic.Machines;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.location.basic.SupportsPortForwarding;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.guava.Maybe;
import brooklyn.util.net.Cidr;
import brooklyn.util.task.DynamicTasks;
import brooklyn.util.task.Tasks;
import brooklyn.util.task.ssh.SshTasks;
import brooklyn.util.task.system.ProcessTaskWrapper;
import brooklyn.util.text.Strings;
import com.google.common.base.Supplier;
import com.google.common.net.HostAndPort;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynAccessUtils {
    private static final Logger log = LoggerFactory.getLogger(BrooklynAccessUtils.class);
    public static final ConfigKey<PortForwardManager> PORT_FORWARDING_MANAGER = new BasicConfigKey<PortForwardManager>(PortForwardManager.class, "brooklyn.portforwarding.manager", "A port-forwarding manager to use at an entity or a location, where supported; note this should normally be a serializable client instance to prevent the creation of multiple disconnected instances via config duplication");
    public static final ConfigKey<Cidr> MANAGEMENT_ACCESS_CIDR = new BasicConfigKey<Object>(Cidr.class, "brooklyn.portforwarding.management.cidr", "CIDR to enable by default for port-forwarding for management", null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static HostAndPort getBrooklynAccessibleAddress(Entity entity, int port) {
        String host;
        Collection ll;
        Maybe<SupportsPortForwarding> machine;
        PortForwardManager pfw = (PortForwardManager)entity.getConfig(PORT_FORWARDING_MANAGER);
        if (pfw != null && (machine = Machines.findUniqueElement(ll = entity.getLocations(), SupportsPortForwarding.class)).isPresent()) {
            Class<BrooklynAccessUtils> clazz = BrooklynAccessUtils.class;
            // MONITORENTER : brooklyn.location.access.BrooklynAccessUtils.class
            HostAndPort hp = pfw.lookup((Location)((MachineLocation)machine.get()), port);
            if (hp != null) {
                // MONITOREXIT : clazz
                return hp;
            }
            Location l = (Location)machine.get();
            if (l instanceof SupportsPortForwarding) {
                Cidr source = (Cidr)entity.getConfig(MANAGEMENT_ACCESS_CIDR);
                if (source != null) {
                    log.debug("BrooklynAccessUtils requesting new port-forwarding rule to access " + port + " on " + entity + " (at " + l + ", enabled for " + source + ")");
                    hp = ((SupportsPortForwarding)l).getSocketEndpointFor(source, port);
                    if (hp != null) {
                        // MONITOREXIT : clazz
                        return hp;
                    }
                } else {
                    log.warn("No " + MANAGEMENT_ACCESS_CIDR.getName() + " configured for " + entity + ", so cannot forward port " + port + " " + "even though " + PORT_FORWARDING_MANAGER.getName() + " was supplied");
                }
            }
            // MONITOREXIT : clazz
        }
        if ((host = (String)entity.getAttribute(Attributes.HOSTNAME)) == null) throw new IllegalStateException("Cannot find way to access port " + port + " on " + entity + " from Brooklyn (no host.name)");
        return HostAndPort.fromParts((String)host, (int)port);
    }

    public static String getResolvedAddress(Entity entity, SshMachineLocation origin, String hostnameTarget) {
        ProcessTaskWrapper task = (ProcessTaskWrapper)SshTasks.newSshExecTaskFactory(origin, "ping -c 1 -t 1 " + hostnameTarget).summary("checking resolution of " + hostnameTarget).allowingNonZeroExitCode().newTask();
        DynamicTasks.queueIfPossible(task).orSubmitAndBlock(entity).asTask().blockUntilEnded();
        if (task.asTask().isError()) {
            log.warn("ping could not be run, at " + entity + " / " + origin + ": " + Tasks.getError(task.asTask()));
            return "";
        }
        if (task.getExitCode() == null || task.getExitCode() != 0) {
            if (task.getExitCode() != null && task.getExitCode() < 10) {
                log.debug("not able to resolve " + hostnameTarget + " from " + origin + " for " + entity + " because exit code was " + task.getExitCode());
                return null;
            }
            log.warn("ping not run as expected, at " + entity + " / " + origin + " (code " + task.getExitCode() + "):\n" + task.getStdout().trim() + " --- " + task.getStderr().trim());
            return "";
        }
        String out = task.getStdout();
        try {
            String line1 = Strings.getFirstLine((String)out);
            String ip = Strings.getFragmentBetween((String)line1, (String)"(", (String)")");
            if (Strings.isNonBlank((CharSequence)ip)) {
                return ip;
            }
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
        }
        if (out.contains("127.0.0.1")) {
            return "127.0.0.1";
        }
        return "";
    }

    public static Supplier<String> resolvedAddressSupplier(final Entity entity, final SshMachineLocation origin, final String hostnameTarget) {
        return new Supplier<String>(){

            public String get() {
                return BrooklynAccessUtils.getResolvedAddress(entity, origin, hostnameTarget);
            }
        };
    }
}

