/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.internal.storage.impl.inmemory;

import brooklyn.internal.storage.DataGrid;
import brooklyn.internal.storage.impl.ConcurrentMapAcceptingNullVals;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class InmemoryDatagrid
implements DataGrid {
    private final Map<String, Map<?, ?>> maps = Maps.newLinkedHashMap();
    private final AtomicInteger creationCounter = new AtomicInteger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, V> ConcurrentMap<K, V> getMap(String id) {
        Map<String, Map<?, ?>> map = this.maps;
        synchronized (map) {
            ConcurrentMap<K, V> result = (ConcurrentMap<K, V>)this.maps.get(id);
            if (result == null) {
                result = this.newMap();
                this.maps.put(id, result);
                this.creationCounter.incrementAndGet();
            }
            return result;
        }
    }

    private <K, V> ConcurrentMap<K, V> newMap() {
        return new ConcurrentMapAcceptingNullVals(Maps.newConcurrentMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String id) {
        Map<String, Map<?, ?>> map = this.maps;
        synchronized (map) {
            this.maps.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate() {
        Map<String, Map<?, ?>> map = this.maps;
        synchronized (map) {
            this.maps.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getDatagridMetrics() {
        Map<String, Map<?, ?>> map = this.maps;
        synchronized (map) {
            return ImmutableMap.of((Object)"size", (Object)this.maps.size(), (Object)"createCount", (Object)this.creationCounter.get());
        }
    }

    @Override
    public Set<String> getKeys() {
        return this.maps.keySet();
    }
}

