/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.internal.storage.impl;

import com.google.common.base.Preconditions;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;

public class ConcurrentMapAcceptingNullVals<K, V>
implements ConcurrentMap<K, V> {
    private final ConcurrentMap<K, V> delegate;

    public ConcurrentMapAcceptingNullVals(ConcurrentMap<K, V> delegate) {
        this.delegate = (ConcurrentMap)Preconditions.checkNotNull(delegate, (Object)"delegate");
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(ConcurrentMapAcceptingNullVals.toNonNullValue(value));
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        LinkedHashSet result = new LinkedHashSet(this.delegate.size());
        for (Map.Entry entry : this.delegate.entrySet()) {
            result.add(new AbstractMap.SimpleEntry(entry.getKey(), ConcurrentMapAcceptingNullVals.fromNonNullValue(entry.getValue())));
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Collection<V> values() {
        ArrayList<Object> result = new ArrayList<Object>(this.delegate.size());
        for (Object v : this.delegate.values()) {
            result.add(ConcurrentMapAcceptingNullVals.fromNonNullValue(v));
        }
        return Collections.unmodifiableCollection(result);
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public V get(Object key) {
        return (V)ConcurrentMapAcceptingNullVals.fromNonNullValue(this.delegate.get(key));
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public V put(K key, V value) {
        return (V)ConcurrentMapAcceptingNullVals.fromNonNullValue(this.delegate.put(key, ConcurrentMapAcceptingNullVals.toNonNullValue(value)));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> vals) {
        for (Map.Entry<K, V> entry : vals.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        return (V)ConcurrentMapAcceptingNullVals.fromNonNullValue(this.delegate.remove(key));
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return (V)ConcurrentMapAcceptingNullVals.fromNonNullValue(this.delegate.putIfAbsent(key, ConcurrentMapAcceptingNullVals.toNonNullValue(value)));
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.delegate.remove(key, ConcurrentMapAcceptingNullVals.toNonNullValue(value));
    }

    @Override
    public V replace(K key, V value) {
        return (V)ConcurrentMapAcceptingNullVals.fromNonNullValue(this.delegate.replace(key, ConcurrentMapAcceptingNullVals.toNonNullValue(value)));
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.delegate.replace(key, ConcurrentMapAcceptingNullVals.toNonNullValue(oldValue), ConcurrentMapAcceptingNullVals.toNonNullValue(newValue));
    }

    private static Object toNonNullValue(Object value) {
        return value != null ? value : Marker.NULL;
    }

    private static Object fromNonNullValue(Object value) {
        return value == Marker.NULL ? null : value;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Map) {
            Map o = (Map)object;
            return this.entrySet().equals(o.entrySet());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.entrySet().hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    private static class SetWithNullVals<T>
    implements Set<T> {
        private final Set<T> delegate;

        public SetWithNullVals(Set<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean add(T e) {
            return this.delegate.add(e);
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            return this.delegate.addAll(c);
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.delegate.contains(ConcurrentMapAcceptingNullVals.toNonNullValue(o));
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Object e : c) {
                if (this.delegate.contains(ConcurrentMapAcceptingNullVals.toNonNullValue(e))) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public Iterator<T> iterator() {
            return null;
        }

        @Override
        public boolean remove(Object o) {
            return this.delegate.remove(ConcurrentMapAcceptingNullVals.toNonNullValue(o));
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean result = false;
            for (Object e : c) {
                result &= this.delegate.remove(ConcurrentMapAcceptingNullVals.toNonNullValue(e));
            }
            return result;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            boolean result = false;
            Iterator<T> iter = this.delegate.iterator();
            while (iter.hasNext()) {
                T e = iter.next();
                if (c.contains(ConcurrentMapAcceptingNullVals.fromNonNullValue(e))) continue;
                iter.remove();
                result = true;
            }
            return result;
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public Object[] toArray() {
            return null;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return null;
        }
    }

    private static enum Marker {
        NULL;

    }
}

