/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.internal.storage.impl;

import brooklyn.internal.storage.BrooklynStorage;
import brooklyn.internal.storage.DataGrid;
import brooklyn.internal.storage.Reference;
import brooklyn.internal.storage.impl.BackedReference;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public class BrooklynStorageImpl
implements BrooklynStorage {
    private final DataGrid datagrid;
    private final ConcurrentMap<String, Object> refsMap;
    private final ConcurrentMap<String, Object> listsMap;
    private final ConcurrentMap<String, WeakReference<Reference<?>>> refsCache;
    private final ConcurrentMap<String, WeakReference<Reference<?>>> listRefsCache;

    public BrooklynStorageImpl(DataGrid datagrid) {
        this.datagrid = datagrid;
        this.refsMap = datagrid.getMap("refs");
        this.listsMap = datagrid.getMap("lists");
        this.refsCache = Maps.newConcurrentMap();
        this.listRefsCache = Maps.newConcurrentMap();
    }

    @VisibleForTesting
    public DataGrid getDataGrid() {
        return this.datagrid;
    }

    @Override
    public <T> Reference<T> getReference(final String id) {
        Reference ref;
        WeakReference weakRef = (WeakReference)this.refsCache.get(id);
        Reference reference = ref = weakRef != null ? (Reference)weakRef.get() : null;
        if (ref == null) {
            ref = new BackedReference<T>(this.refsMap, id){

                protected void finalize() {
                    BrooklynStorageImpl.this.refsCache.remove(id);
                }
            };
            this.refsCache.putIfAbsent(id, new WeakReference<Reference>(ref));
        }
        return ref;
    }

    @Override
    public <T> Reference<List<T>> getNonConcurrentList(final String id) {
        Reference ref;
        WeakReference weakRef = (WeakReference)this.listRefsCache.get(id);
        Reference reference = ref = weakRef != null ? (Reference)weakRef.get() : null;
        if (ref == null) {
            ref = new BackedReference<List<T>>(this.listsMap, id){

                @Override
                public List<T> get() {
                    List result = (List)super.get();
                    return result == null ? ImmutableList.of() : Collections.unmodifiableList(result);
                }

                protected void finalize() {
                    BrooklynStorageImpl.this.listRefsCache.remove(id);
                }
            };
            this.listRefsCache.putIfAbsent(id, new WeakReference<Reference>(ref));
        }
        return ref;
    }

    @Override
    public <K, V> ConcurrentMap<K, V> getMap(String id) {
        return this.datagrid.getMap(id);
    }

    @Override
    public void remove(String id) {
        this.datagrid.remove(id);
        this.refsMap.remove(id);
        this.listsMap.remove(id);
        this.refsCache.remove(id);
        this.listRefsCache.remove(id);
    }

    @Override
    public void terminate() {
        this.datagrid.terminate();
    }

    @Override
    public boolean isMostlyEmpty() {
        return this.refsMap.isEmpty() && this.listsMap.isEmpty();
    }

    @Override
    public Map<String, Object> getStorageMetrics() {
        return ImmutableMap.of((Object)"datagrid", this.datagrid.getDatagridMetrics(), (Object)"refsMapSize", (Object)("" + this.refsMap.size()), (Object)"listsMapSize", (Object)("" + this.listsMap.size()));
    }

    public String toString() {
        return super.toString() + this.getStorageMetrics();
    }
}

