/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.internal;

import brooklyn.location.basic.PortRanges;
import brooklyn.util.BrooklynLanguageExtensions;
import brooklyn.util.crypto.SecureKeys;
import brooklyn.util.flags.TypeCoercions;
import brooklyn.util.net.Networking;
import com.google.common.annotations.Beta;
import java.util.concurrent.atomic.AtomicBoolean;

@Beta
public class BrooklynInitialization {
    private static AtomicBoolean done = new AtomicBoolean(false);

    public static void initTypeCoercionStandardAdapters() {
        TypeCoercions.initStandardAdapters();
    }

    public static void initSecureKeysBouncyCastleProvider() {
        SecureKeys.initBouncyCastleProvider();
    }

    public static void initNetworking() {
        Networking.init();
    }

    public static void initPortRanges() {
        PortRanges.init();
    }

    public static void initLegacyLanguageExtensions() {
        BrooklynLanguageExtensions.init();
    }

    public static synchronized void initAll() {
        if (done.get()) {
            return;
        }
        BrooklynInitialization.initTypeCoercionStandardAdapters();
        BrooklynInitialization.initSecureKeysBouncyCastleProvider();
        BrooklynInitialization.initNetworking();
        BrooklynInitialization.initPortRanges();
        BrooklynInitialization.initLegacyLanguageExtensions();
        done.set(true);
    }

    public static synchronized void reinitAll() {
        done.set(false);
        BrooklynLanguageExtensions.reinit();
        BrooklynInitialization.initAll();
    }
}

