/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.internal;

import brooklyn.config.BrooklynProperties;
import com.google.common.annotations.Beta;
import com.google.common.collect.Maps;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class BrooklynFeatureEnablement {
    private static final Logger LOG = LoggerFactory.getLogger(BrooklynFeatureEnablement.class);
    public static final String FEATURE_PROPERTY_PREFIX = "brooklyn.experimental.feature";
    public static final String FEATURE_POLICY_PERSISTENCE_PROPERTY = "brooklyn.experimental.feature.policyPersistence";
    public static final String FEATURE_ENRICHER_PERSISTENCE_PROPERTY = "brooklyn.experimental.feature.enricherPersistence";
    public static final String FEATURE_FEED_PERSISTENCE_PROPERTY = "brooklyn.experimental.feature.feedPersistence";
    public static final String FEATURE_FEED_REGISTRATION_PROPERTY = "brooklyn.experimental.feature.feedRegistration";
    public static final String FEATURE_CATALOG_PERSISTENCE_PROPERTY = "brooklyn.experimental.feature.catalogPersistence";
    public static final String FEATURE_DEFAULT_STANDBY_IS_HOT_PROPERTY = "brooklyn.experimental.feature.defaultStandbyIsHot";
    public static final String FEATURE_USE_BROOKLYN_LIVE_OBJECTS_DATAGRID_STORAGE = "brooklyn.experimental.feature.useBrooklynLiveObjectsDatagridStorage";
    public static final String FEATURE_RENAME_THREADS = "brooklyn.executionManager.renameThreads";
    public static final String FEATURE_BACKWARDS_COMPATIBILITY_INFER_CATALOG_ITEM_ON_REBIND = "brooklyn.backwardCompatibility.feature.inferCatalogItemOnRebind";
    public static final String FEATURE_AUTO_FIX_CATALOG_REF_ON_REBIND = "brooklyn.quickfix.fixDanglingCatalogItemOnRebind";
    public static final String FEATURE_SSH_ASYNC_EXEC = "brooklyn.experimental.feature.ssh.asyncExec";
    public static final String FEATURE_VALIDATE_LOCATION_SSH_KEYS = "brooklyn.validate.locationSshKeys";
    private static final Map<String, Boolean> FEATURE_ENABLEMENTS = Maps.newLinkedHashMap();
    private static final Object MUTEX = new Object();

    static void setDefaults() {
        BrooklynFeatureEnablement.setDefault(FEATURE_POLICY_PERSISTENCE_PROPERTY, true);
        BrooklynFeatureEnablement.setDefault(FEATURE_ENRICHER_PERSISTENCE_PROPERTY, true);
        BrooklynFeatureEnablement.setDefault(FEATURE_FEED_PERSISTENCE_PROPERTY, true);
        BrooklynFeatureEnablement.setDefault(FEATURE_FEED_REGISTRATION_PROPERTY, false);
        BrooklynFeatureEnablement.setDefault(FEATURE_CATALOG_PERSISTENCE_PROPERTY, true);
        BrooklynFeatureEnablement.setDefault(FEATURE_DEFAULT_STANDBY_IS_HOT_PROPERTY, false);
        BrooklynFeatureEnablement.setDefault(FEATURE_USE_BROOKLYN_LIVE_OBJECTS_DATAGRID_STORAGE, false);
        BrooklynFeatureEnablement.setDefault(FEATURE_RENAME_THREADS, false);
        BrooklynFeatureEnablement.setDefault(FEATURE_BACKWARDS_COMPATIBILITY_INFER_CATALOG_ITEM_ON_REBIND, true);
        BrooklynFeatureEnablement.setDefault(FEATURE_AUTO_FIX_CATALOG_REF_ON_REBIND, false);
        BrooklynFeatureEnablement.setDefault(FEATURE_SSH_ASYNC_EXEC, false);
        BrooklynFeatureEnablement.setDefault(FEATURE_VALIDATE_LOCATION_SSH_KEYS, true);
    }

    public static void init(BrooklynProperties props) {
        boolean changed = false;
        for (Map.Entry<String, Object> entry : props.asMapWithStringKeys().entrySet()) {
            String property = entry.getKey();
            if (!property.startsWith(FEATURE_PROPERTY_PREFIX) || FEATURE_ENABLEMENTS.containsKey(property)) continue;
            Object rawVal = System.getProperty(property);
            if (rawVal == null) {
                rawVal = entry.getValue();
            }
            boolean val = Boolean.parseBoolean("" + rawVal);
            FEATURE_ENABLEMENTS.put(property, val);
            changed = true;
            LOG.debug("Init feature enablement of " + property + " set to " + val);
        }
        if (!changed) {
            LOG.debug("Init feature enablement did nothing, as no settings in brooklyn properties");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEnabled(String property) {
        Object object = MUTEX;
        synchronized (object) {
            if (!FEATURE_ENABLEMENTS.containsKey(property)) {
                String rawVal = System.getProperty(property);
                boolean val = Boolean.parseBoolean(rawVal);
                FEATURE_ENABLEMENTS.put(property, val);
            }
            return FEATURE_ENABLEMENTS.get(property);
        }
    }

    public static boolean enable(String property) {
        return BrooklynFeatureEnablement.setEnablement(property, true);
    }

    public static boolean disable(String property) {
        return BrooklynFeatureEnablement.setEnablement(property, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setEnablement(String property, boolean val) {
        Object object = MUTEX;
        synchronized (object) {
            boolean oldVal = BrooklynFeatureEnablement.isEnabled(property);
            FEATURE_ENABLEMENTS.put(property, val);
            return oldVal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setDefault(String property, boolean val) {
        Object object = MUTEX;
        synchronized (object) {
            if (!FEATURE_ENABLEMENTS.containsKey(property)) {
                String rawVal = System.getProperty(property);
                if (rawVal == null) {
                    FEATURE_ENABLEMENTS.put(property, val);
                    LOG.debug("Default enablement of " + property + " set to " + val);
                } else {
                    LOG.debug("Not setting default enablement of " + property + " to " + val + ", because system property is " + rawVal);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearCache() {
        Object object = MUTEX;
        synchronized (object) {
            FEATURE_ENABLEMENTS.clear();
            BrooklynFeatureEnablement.setDefaults();
        }
    }

    static {
        BrooklynFeatureEnablement.setDefaults();
    }
}

