/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.event.feed.windows;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.effector.EffectorTasks;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.Sensors;
import brooklyn.event.feed.AbstractFeed;
import brooklyn.event.feed.PollHandler;
import brooklyn.event.feed.Poller;
import brooklyn.event.feed.windows.WindowsPerformanceCounterPollConfig;
import brooklyn.location.basic.WinRmMachineLocation;
import brooklyn.management.ExecutionContext;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.flags.TypeCoercions;
import brooklyn.util.time.Duration;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import io.cloudsoft.winrm4j.winrm.WinRmToolResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsPerformanceCounterFeed
extends AbstractFeed {
    private static final Logger log = LoggerFactory.getLogger(WindowsPerformanceCounterFeed.class);
    protected static final Pattern lineWithPerfData = Pattern.compile("^\"[\\d:/\\-. ]+\",\".*\"$", 8);
    private static final Joiner JOINER_ON_SPACE = Joiner.on((char)' ');
    private static final Joiner JOINER_ON_COMMA = Joiner.on((char)',');
    public static final ConfigKey<Collection<WindowsPerformanceCounterPollConfig<?>>> POLLS = ConfigKeys.newConfigKey(new TypeToken<Collection<WindowsPerformanceCounterPollConfig<?>>>(){}, "polls");

    public static Builder builder() {
        return new Builder();
    }

    public WindowsPerformanceCounterFeed() {
    }

    protected WindowsPerformanceCounterFeed(Builder builder) {
        ArrayList polls = Lists.newArrayList();
        for (WindowsPerformanceCounterPollConfig config : builder.polls) {
            WindowsPerformanceCounterPollConfig configCopy = new WindowsPerformanceCounterPollConfig(config);
            if (configCopy.getPeriod() < 0L) {
                configCopy.period(builder.period);
            }
            polls.add(configCopy);
        }
        this.config().set(POLLS, polls);
        this.initUniqueTag(builder.uniqueTag, polls);
    }

    @Override
    protected void preStart() {
        Collection<WindowsPerformanceCounterPollConfig<?>> polls = this.getConfig(POLLS);
        long minPeriod = Integer.MAX_VALUE;
        ArrayList performanceCounterNames = Lists.newArrayList();
        for (WindowsPerformanceCounterPollConfig<?> config : polls) {
            minPeriod = Math.min(minPeriod, config.getPeriod());
            performanceCounterNames.add(config.getPerformanceCounterName());
        }
        ImmutableList allParams = ImmutableList.builder().add((Object)"Get-Counter").add((Object)"-Counter").add((Object)JOINER_ON_COMMA.join(Iterables.transform((Iterable)performanceCounterNames, (Function)QuoteStringFunction.INSTANCE))).add((Object)"-SampleInterval").add((Object)"2").build();
        String command = String.format("(%s).CounterSamples.CookedValue", JOINER_ON_SPACE.join((Iterable)allParams));
        log.debug("Windows performance counter poll command for {} will be: {}", (Object)this.entity, (Object)command);
        GetPerformanceCountersJob job = new GetPerformanceCountersJob((Entity)this.getEntity(), command);
        this.getPoller().scheduleAtFixedRate(new CallInEntityExecutionContext(this.entity, job), (PollHandler<WinRmToolResponse>)new SendPerfCountersToSensors(this.getEntity(), this.getConfig(POLLS)), minPeriod);
    }

    protected Poller<WinRmToolResponse> getPoller() {
        return super.getPoller();
    }

    private static enum QuoteStringFunction implements Function<String, String>
    {
        INSTANCE;


        @Nullable
        public String apply(@Nullable String input) {
            return input != null ? "\"" + input + "\"" : null;
        }
    }

    static class PerfCounterValueIterator
    implements Iterator<String> {
        protected static final Pattern splitPerfData = Pattern.compile("^\"([^\\\"]*)\"((,\"[^\\\"]*\")*)$");
        private Matcher matcher;

        public PerfCounterValueIterator(String input) {
            this.matcher = splitPerfData.matcher(input);
            Preconditions.checkArgument((boolean)this.hasNext(), (Object)("input " + input + " does not match expected pattern " + splitPerfData.pattern()));
            this.next();
        }

        @Override
        public boolean hasNext() {
            return this.matcher != null && this.matcher.find();
        }

        @Override
        public String next() {
            String next = this.matcher.group(1);
            String remainder = this.matcher.group(2);
            if (!Strings.isNullOrEmpty((String)remainder)) {
                assert (remainder.startsWith(","));
                remainder = remainder.substring(1);
                this.matcher = splitPerfData.matcher(remainder);
            } else {
                this.matcher = null;
            }
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class SendPerfCountersToSensors
    implements PollHandler<WinRmToolResponse> {
        private final EntityLocal entity;
        private final List<WindowsPerformanceCounterPollConfig<?>> polls;
        private final Set<AttributeSensor<?>> failedAttributes = Sets.newLinkedHashSet();

        public SendPerfCountersToSensors(EntityLocal entity, Collection<WindowsPerformanceCounterPollConfig<?>> polls) {
            this.entity = entity;
            this.polls = ImmutableList.copyOf(polls);
        }

        @Override
        public boolean checkSuccess(WinRmToolResponse val) {
            if (val.getStatusCode() != 0) {
                return false;
            }
            String stderr = val.getStdErr();
            if (stderr == null || stderr.length() != 0) {
                return false;
            }
            String out = val.getStdOut();
            return out != null && out.length() != 0;
        }

        @Override
        public void onSuccess(WinRmToolResponse val) {
            String[] values = val.getStdOut().split("\r\n");
            for (int i = 0; i < this.polls.size(); ++i) {
                WindowsPerformanceCounterPollConfig<?> config = this.polls.get(i);
                Class clazz = config.getSensor().getType();
                AttributeSensor attribute = Sensors.newSensor(clazz, config.getSensor().getName(), config.getDescription());
                try {
                    Object value = TypeCoercions.coerce((Object)values[i], TypeToken.of((Class)clazz));
                    this.entity.setAttribute(attribute, value);
                    continue;
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                    if (this.failedAttributes.add(attribute)) {
                        log.warn("Failed to coerce value '{}' to {} for {} -> {}", new Object[]{values[i], clazz, this.entity, attribute});
                        continue;
                    }
                    if (!log.isTraceEnabled()) continue;
                    log.trace("Failed (repeatedly) to coerce value '{}' to {} for {} -> {}", new Object[]{values[i], clazz, this.entity, attribute});
                }
            }
        }

        @Override
        public void onFailure(WinRmToolResponse val) {
            log.error("Windows Performance Counter query did not respond as expected. exitcode={} stdout={} stderr={}", new Object[]{val.getStatusCode(), val.getStdOut(), val.getStdErr()});
            for (WindowsPerformanceCounterPollConfig<?> config : this.polls) {
                Class clazz = config.getSensor().getType();
                AttributeSensor attribute = Sensors.newSensor(clazz, config.getSensor().getName(), config.getDescription());
                this.entity.setAttribute(attribute, null);
            }
        }

        @Override
        public void onException(Exception exception) {
            log.error("Detected exception while retrieving Windows Performance Counters from entity " + this.entity.getDisplayName(), (Throwable)exception);
            for (WindowsPerformanceCounterPollConfig<?> config : this.polls) {
                this.entity.setAttribute(Sensors.newSensor(config.getSensor().getClass(), config.getPerformanceCounterName(), config.getDescription()), null);
            }
        }

        @Override
        public String getDescription() {
            return "" + this.polls;
        }

        public String toString() {
            return super.toString() + "[" + this.getDescription() + "]";
        }
    }

    private static class CallInEntityExecutionContext<T>
    implements Callable<T> {
        private final Callable<T> job;
        private EntityLocal entity;

        private CallInEntityExecutionContext(EntityLocal entity, Callable<T> job) {
            this.job = job;
            this.entity = entity;
        }

        @Override
        public T call() throws Exception {
            ExecutionContext executionContext = ((EntityInternal)this.entity).getManagementSupport().getExecutionContext();
            return (T)executionContext.submit((Map)Maps.newHashMap(), this.job).get();
        }
    }

    private static class GetPerformanceCountersJob<T>
    implements Callable<T> {
        private final Entity entity;
        private final String command;

        GetPerformanceCountersJob(Entity entity, String command) {
            this.entity = entity;
            this.command = command;
        }

        @Override
        public T call() throws Exception {
            WinRmMachineLocation machine = EffectorTasks.getWinRmMachine(this.entity);
            WinRmToolResponse response = machine.executePsScript(this.command);
            return (T)response;
        }
    }

    public static class Builder {
        private EntityLocal entity;
        private Set<WindowsPerformanceCounterPollConfig<?>> polls = Sets.newLinkedHashSet();
        private Duration period = Duration.of((long)30L, (TimeUnit)TimeUnit.SECONDS);
        private String uniqueTag;
        private volatile boolean built;

        public Builder entity(EntityLocal val) {
            this.entity = (EntityLocal)Preconditions.checkNotNull((Object)val, (Object)"entity");
            return this;
        }

        public Builder addSensor(WindowsPerformanceCounterPollConfig<?> config) {
            this.polls.add(config);
            return this;
        }

        public Builder addSensor(String performanceCounterName, AttributeSensor<?> sensor) {
            return this.addSensor(new WindowsPerformanceCounterPollConfig(sensor).performanceCounterName((String)Preconditions.checkNotNull((Object)performanceCounterName, (Object)"performanceCounterName")));
        }

        public Builder addSensors(Map<String, AttributeSensor> sensors) {
            for (Map.Entry<String, AttributeSensor> entry : sensors.entrySet()) {
                this.addSensor(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public Builder period(Duration period) {
            this.period = (Duration)Preconditions.checkNotNull((Object)period, (Object)"period");
            return this;
        }

        public Builder period(long millis) {
            return this.period(millis, TimeUnit.MILLISECONDS);
        }

        public Builder period(long val, TimeUnit units) {
            return this.period(Duration.of((long)val, (TimeUnit)units));
        }

        public Builder uniqueTag(String uniqueTag) {
            this.uniqueTag = uniqueTag;
            return this;
        }

        public WindowsPerformanceCounterFeed build() {
            this.built = true;
            WindowsPerformanceCounterFeed result = new WindowsPerformanceCounterFeed(this);
            result.setEntity((EntityLocal)Preconditions.checkNotNull((Object)this.entity, (Object)"entity"));
            result.start();
            return result;
        }

        protected void finalize() {
            if (!this.built) {
                log.warn("WindowsPerformanceCounterFeed.Builder created, but build() never called");
            }
        }
    }
}

