/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.event.feed.ssh;

import brooklyn.event.feed.ssh.SshPollValue;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import javax.annotation.Nullable;

public class SshValueFunctions {
    public static Function<SshPollValue, Integer> exitStatus() {
        return new Function<SshPollValue, Integer>(){

            public Integer apply(SshPollValue input) {
                return input.getExitStatus();
            }
        };
    }

    public static Function<SshPollValue, String> stdout() {
        return new Function<SshPollValue, String>(){

            public String apply(SshPollValue input) {
                return input.getStdout();
            }
        };
    }

    public static Function<SshPollValue, String> stderr() {
        return new Function<SshPollValue, String>(){

            public String apply(SshPollValue input) {
                return input.getStderr();
            }
        };
    }

    public static Function<SshPollValue, Boolean> exitStatusEquals(int expected) {
        return SshValueFunctions.chain(SshValueFunctions.exitStatus(), Functions.forPredicate((Predicate)Predicates.equalTo((Object)expected)));
    }

    public static <A, B, C> Function<A, C> chain(final Function<A, ? extends B> f1, final Function<B, C> f2) {
        return new Function<A, C>(){

            public C apply(@Nullable A input) {
                return f2.apply(f1.apply(input));
            }
        };
    }

    public static <A, B, C, D> Function<A, D> chain(final Function<A, ? extends B> f1, final Function<B, ? extends C> f2, final Function<C, D> f3) {
        return new Function<A, D>(){

            public D apply(@Nullable A input) {
                return f3.apply(f2.apply(f1.apply(input)));
            }
        };
    }
}

