/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.event.feed.ssh;

import brooklyn.event.AttributeSensor;
import brooklyn.event.feed.PollConfig;
import brooklyn.event.feed.ssh.SshPollValue;
import brooklyn.util.collections.MutableList;
import brooklyn.util.collections.MutableMap;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class SshPollConfig<T>
extends PollConfig<SshPollValue, T, SshPollConfig<T>> {
    private Supplier<String> commandSupplier;
    private List<Supplier<Map<String, String>>> dynamicEnvironmentSupplier = MutableList.of();
    public static final Predicate<SshPollValue> DEFAULT_SUCCESS = new Predicate<SshPollValue>(){

        public boolean apply(@Nullable SshPollValue input) {
            return input != null && input.getExitStatus() == 0;
        }
    };

    public SshPollConfig(AttributeSensor<T> sensor) {
        super(sensor);
        super.checkSuccess(DEFAULT_SUCCESS);
    }

    public SshPollConfig(SshPollConfig<T> other) {
        super(other);
        this.commandSupplier = other.commandSupplier;
    }

    public String getCommand() {
        return (String)this.getCommandSupplier().get();
    }

    public Supplier<String> getCommandSupplier() {
        return this.commandSupplier;
    }

    public Map<String, String> getEnv() {
        return (Map)this.getEnvSupplier().get();
    }

    public Supplier<Map<String, String>> getEnvSupplier() {
        return new Supplier<Map<String, String>>(){

            public Map<String, String> get() {
                MutableMap result = MutableMap.of();
                for (Supplier envS : SshPollConfig.this.dynamicEnvironmentSupplier) {
                    Map envM;
                    if (envS == null || (envM = (Map)envS.get()) == null) continue;
                    SshPollConfig.this.mergeEnvMaps(envM, (Map<String, String>)result);
                }
                return result;
            }
        };
    }

    protected void mergeEnvMaps(Map<String, String> supplied, Map<String, String> target) {
        if (supplied == null) {
            return;
        }
        target.putAll(supplied);
    }

    public SshPollConfig<T> command(String val) {
        return this.command((Supplier<String>)Suppliers.ofInstance((Object)val));
    }

    public SshPollConfig<T> command(Supplier<String> val) {
        this.commandSupplier = val;
        return this;
    }

    public SshPollConfig<T> env(String key, String val) {
        return this.env(Collections.singletonMap(key, val));
    }

    public SshPollConfig<T> env(Map<String, String> val) {
        if (val == null) {
            return this;
        }
        return this.env((Supplier<Map<String, String>>)Suppliers.ofInstance(val));
    }

    public SshPollConfig<T> env(Supplier<Map<String, String>> val) {
        Preconditions.checkNotNull(val);
        this.dynamicEnvironmentSupplier.add(val);
        return this;
    }

    @Override
    protected String toStringBaseName() {
        return "ssh";
    }

    @Override
    protected Object toStringPollSource() {
        if (this.getCommandSupplier() == null) {
            return null;
        }
        String command = (String)this.getCommandSupplier().get();
        return command;
    }

    @Override
    protected MutableList<Object> equalsFields() {
        return super.equalsFields().appendIfNotNull(this.getCommandSupplier() != null ? (String)this.getCommandSupplier().get() : null).appendIfNotNull(this.getEnvSupplier() != null ? (Map)this.getEnvSupplier().get() : null);
    }
}

