/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.event.feed.ssh;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.event.feed.AbstractFeed;
import brooklyn.event.feed.AttributePollHandler;
import brooklyn.event.feed.DelegatingPollHandler;
import brooklyn.event.feed.Poller;
import brooklyn.event.feed.ssh.SshPollConfig;
import brooklyn.event.feed.ssh.SshPollValue;
import brooklyn.location.basic.Locations;
import brooklyn.location.basic.Machines;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.internal.ssh.SshTool;
import brooklyn.util.time.Duration;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshFeed
extends AbstractFeed {
    public static final Logger log = LoggerFactory.getLogger(SshFeed.class);
    public static final ConfigKey<Supplier<SshMachineLocation>> MACHINE = ConfigKeys.newConfigKey(new TypeToken<Supplier<SshMachineLocation>>(){}, "machine");
    public static final ConfigKey<Boolean> EXEC_AS_COMMAND = ConfigKeys.newBooleanConfigKey("execAsCommand");
    public static final ConfigKey<SetMultimap<SshPollIdentifier, SshPollConfig<?>>> POLLS = ConfigKeys.newConfigKey(new TypeToken<SetMultimap<SshPollIdentifier, SshPollConfig<?>>>(){}, "polls");

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public static SshMachineLocation getMachineOfEntity(Entity entity) {
        return (SshMachineLocation)Machines.findUniqueSshMachineLocation(entity.getLocations()).orNull();
    }

    public SshFeed() {
    }

    protected SshFeed(Builder builder) {
        this.setConfig(ONLY_IF_SERVICE_UP, builder.onlyIfServiceUp);
        this.setConfig(MACHINE, builder.machine != null ? builder.machine : null);
        this.setConfig(EXEC_AS_COMMAND, builder.execAsCommand);
        HashMultimap polls = HashMultimap.create();
        for (SshPollConfig config : builder.polls) {
            SshPollConfig configCopy = new SshPollConfig(config);
            if (configCopy.getPeriod() < 0L) {
                configCopy.period(builder.period);
            }
            polls.put((Object)new SshPollIdentifier(config.getCommandSupplier(), config.getEnvSupplier()), configCopy);
        }
        this.setConfig(POLLS, polls);
        this.initUniqueTag(builder.uniqueTag, polls.values());
    }

    protected SshMachineLocation getMachine() {
        Supplier<SshMachineLocation> supplier = this.getConfig(MACHINE);
        if (supplier != null) {
            return (SshMachineLocation)supplier.get();
        }
        return (SshMachineLocation)Locations.findUniqueSshMachineLocation(this.entity.getLocations()).get();
    }

    @Override
    protected void preStart() {
        SetMultimap<SshPollIdentifier, SshPollConfig<?>> polls = this.getConfig(POLLS);
        for (final SshPollIdentifier pollInfo : polls.keySet()) {
            Set configs = polls.get((Object)pollInfo);
            long minPeriod = Integer.MAX_VALUE;
            LinkedHashSet handlers = Sets.newLinkedHashSet();
            for (SshPollConfig config : configs) {
                handlers.add(new AttributePollHandler(config, this.entity, this));
                if (config.getPeriod() <= 0L) continue;
                minPeriod = Math.min(minPeriod, config.getPeriod());
            }
            this.getPoller().scheduleAtFixedRate(new Callable<SshPollValue>(){

                @Override
                public SshPollValue call() throws Exception {
                    return SshFeed.this.exec((String)pollInfo.command.get(), (Map)pollInfo.env.get());
                }
            }, new DelegatingPollHandler(handlers), minPeriod);
        }
    }

    protected Poller<SshPollValue> getPoller() {
        return super.getPoller();
    }

    private SshPollValue exec(String command, Map<String, String> env) throws IOException {
        SshMachineLocation machine = this.getMachine();
        Boolean execAsCommand = this.getConfig(EXEC_AS_COMMAND);
        if (log.isTraceEnabled()) {
            log.trace("Ssh polling for {}, executing {} with env {}", new Object[]{machine, command, env});
        }
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        ByteArrayOutputStream stderr = new ByteArrayOutputStream();
        ConfigBag flags = ConfigBag.newInstance().configure(SshTool.PROP_NO_EXTRA_OUTPUT, true).configure(SshTool.PROP_OUT_STREAM, stdout).configure(SshTool.PROP_ERR_STREAM, stderr);
        int exitStatus = Boolean.TRUE.equals(execAsCommand) ? machine.execCommands(flags.getAllConfig(), "ssh-feed", (List<String>)ImmutableList.of((Object)command), env) : machine.execScript(flags.getAllConfig(), "ssh-feed", (List<String>)ImmutableList.of((Object)command), env);
        return new SshPollValue(machine, exitStatus, new String(stdout.toByteArray()), new String(stderr.toByteArray()));
    }

    private static class SshPollIdentifier {
        final Supplier<String> command;
        final Supplier<Map<String, String>> env;

        private SshPollIdentifier(Supplier<String> command, Supplier<Map<String, String>> env) {
            this.command = (Supplier)Preconditions.checkNotNull(command, (Object)"command");
            this.env = (Supplier)Preconditions.checkNotNull(env, (Object)"env");
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.command, this.env});
        }

        public boolean equals(Object other) {
            if (!(other instanceof SshPollIdentifier)) {
                return false;
            }
            SshPollIdentifier o = (SshPollIdentifier)other;
            return Objects.equal(this.command, o.command) && Objects.equal(this.env, o.env);
        }
    }

    public static class Builder {
        private EntityLocal entity;
        private boolean onlyIfServiceUp = false;
        private Supplier<SshMachineLocation> machine;
        private Duration period = Duration.of((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
        private List<SshPollConfig<?>> polls = Lists.newArrayList();
        private boolean execAsCommand = false;
        private String uniqueTag;
        private volatile boolean built;

        public Builder entity(EntityLocal val) {
            this.entity = val;
            return this;
        }

        public Builder onlyIfServiceUp() {
            return this.onlyIfServiceUp(true);
        }

        public Builder onlyIfServiceUp(boolean onlyIfServiceUp) {
            this.onlyIfServiceUp = onlyIfServiceUp;
            return this;
        }

        public Builder machine(SshMachineLocation val) {
            return this.machine((Supplier<SshMachineLocation>)Suppliers.ofInstance((Object)val));
        }

        public Builder machine(Supplier<SshMachineLocation> val) {
            this.machine = val;
            return this;
        }

        public Builder period(Duration period) {
            this.period = period;
            return this;
        }

        public Builder period(long millis) {
            return this.period(Duration.of((long)millis, (TimeUnit)TimeUnit.MILLISECONDS));
        }

        public Builder period(long val, TimeUnit units) {
            return this.period(Duration.of((long)val, (TimeUnit)units));
        }

        public Builder poll(SshPollConfig<?> config) {
            this.polls.add(config);
            return this;
        }

        public Builder execAsCommand() {
            this.execAsCommand = true;
            return this;
        }

        public Builder execAsScript() {
            this.execAsCommand = false;
            return this;
        }

        public Builder uniqueTag(String uniqueTag) {
            this.uniqueTag = uniqueTag;
            return this;
        }

        public SshFeed build() {
            this.built = true;
            SshFeed result = new SshFeed(this);
            result.setEntity((EntityLocal)Preconditions.checkNotNull((Object)this.entity, (Object)"entity"));
            result.start();
            return result;
        }

        protected void finalize() {
            if (!this.built) {
                log.warn("SshFeed.Builder created, but build() never called");
            }
        }
    }
}

