/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.event.feed.shell;

import brooklyn.event.AttributeSensor;
import brooklyn.event.feed.PollConfig;
import brooklyn.event.feed.ssh.SshPollValue;
import brooklyn.util.collections.MutableList;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class ShellPollConfig<T>
extends PollConfig<SshPollValue, T, ShellPollConfig<T>> {
    private String command;
    private Map<String, String> env = Maps.newLinkedHashMap();
    private long timeout = -1L;
    private File dir;
    private String input;
    public static final Predicate<SshPollValue> DEFAULT_SUCCESS = new Predicate<SshPollValue>(){

        public boolean apply(@Nullable SshPollValue input) {
            return input != null && input.getExitStatus() == 0;
        }
    };

    public ShellPollConfig(AttributeSensor<T> sensor) {
        super(sensor);
        super.checkSuccess(DEFAULT_SUCCESS);
    }

    public ShellPollConfig(ShellPollConfig<T> other) {
        super(other);
        this.command = other.command;
        this.env = other.env;
        this.timeout = other.timeout;
        this.dir = other.dir;
        this.input = other.input;
    }

    public String getCommand() {
        return this.command;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public File getDir() {
        return this.dir;
    }

    public String getInput() {
        return this.input;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public ShellPollConfig<T> command(String val) {
        this.command = val;
        return this;
    }

    public ShellPollConfig<T> env(String key, String val) {
        this.env.put((String)Preconditions.checkNotNull((Object)key, (Object)"key"), (String)Preconditions.checkNotNull((Object)val, (Object)"val"));
        return this;
    }

    public ShellPollConfig<T> env(Map<String, String> val) {
        for (Map.Entry entry : ((Map)Preconditions.checkNotNull(val, (Object)"map")).entrySet()) {
            this.env((String)entry.getKey(), (String)entry.getValue());
        }
        return this;
    }

    public ShellPollConfig<T> dir(File val) {
        this.dir = val;
        return this;
    }

    public ShellPollConfig<T> input(String val) {
        this.input = val;
        return this;
    }

    public ShellPollConfig<T> timeout(long timeout) {
        return this.timeout(timeout, TimeUnit.MILLISECONDS);
    }

    public ShellPollConfig<T> timeout(long timeout, TimeUnit units) {
        this.timeout = units.toMillis(timeout);
        return this;
    }

    @Override
    protected String toStringBaseName() {
        return "shell";
    }

    @Override
    protected String toStringPollSource() {
        return this.command;
    }

    @Override
    protected MutableList<Object> equalsFields() {
        return super.equalsFields().appendIfNotNull((Object)this.command);
    }
}

