/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.event.feed.http;

import brooklyn.util.guava.Functionals;
import brooklyn.util.guava.Maybe;
import brooklyn.util.guava.MaybeFunctions;
import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;

public class JsonFunctions {
    private JsonFunctions() {
    }

    public static Function<String, JsonElement> asJson() {
        return new Function<String, JsonElement>(){

            public JsonElement apply(String input) {
                return new JsonParser().parse(input);
            }
        };
    }

    public static <T> Function<JsonElement, List<T>> forEach(final Function<JsonElement, T> func) {
        return new Function<JsonElement, List<T>>(){

            public List<T> apply(JsonElement input) {
                JsonArray array = (JsonArray)input;
                ArrayList result = Lists.newArrayList();
                for (int i = 0; i < array.size(); ++i) {
                    result.add(func.apply((Object)array.get(i)));
                }
                return result;
            }
        };
    }

    public static Function<JsonElement, JsonElement> walk(String elementOrDotSeparatedElements) {
        return JsonFunctions.walk(Splitter.on((char)'.').split((CharSequence)elementOrDotSeparatedElements));
    }

    public static Function<JsonElement, JsonElement> walk(String ... elements) {
        return JsonFunctions.walk(Arrays.asList(elements));
    }

    public static Function<JsonElement, JsonElement> walk(final Iterable<String> elements) {
        return new Function<JsonElement, JsonElement>(){

            public JsonElement apply(JsonElement input) {
                JsonElement curr = input;
                for (String element : elements) {
                    JsonObject jo = curr.getAsJsonObject();
                    if ((curr = jo.get(element)) != null) continue;
                    throw new NoSuchElementException("No element '" + element + " in JSON, when walking " + elements);
                }
                return curr;
            }
        };
    }

    public static Function<JsonElement, JsonElement> walkN(@Nullable String elements) {
        return JsonFunctions.walkN(Splitter.on((char)'.').split((CharSequence)elements));
    }

    public static Function<JsonElement, JsonElement> walkN(String ... elements) {
        return JsonFunctions.walkN(Arrays.asList(elements));
    }

    public static Function<JsonElement, JsonElement> walkN(final Iterable<String> elements) {
        return new Function<JsonElement, JsonElement>(){

            public JsonElement apply(JsonElement input) {
                JsonElement curr = input;
                for (String element : elements) {
                    if (curr == null) {
                        return null;
                    }
                    JsonObject jo = curr.getAsJsonObject();
                    curr = jo.get(element);
                }
                return curr;
            }
        };
    }

    public static Function<Maybe<JsonElement>, Maybe<JsonElement>> walkM(@Nullable String elements) {
        return JsonFunctions.walkM(Splitter.on((char)'.').split((CharSequence)elements));
    }

    public static Function<Maybe<JsonElement>, Maybe<JsonElement>> walkM(String ... elements) {
        return JsonFunctions.walkM(Arrays.asList(elements));
    }

    public static Function<Maybe<JsonElement>, Maybe<JsonElement>> walkM(final Iterable<String> elements) {
        return new Function<Maybe<JsonElement>, Maybe<JsonElement>>(){

            public Maybe<JsonElement> apply(Maybe<JsonElement> input) {
                Maybe curr = input;
                for (String element : elements) {
                    if (curr.isAbsent()) {
                        return curr;
                    }
                    JsonObject jo = ((JsonElement)curr.get()).getAsJsonObject();
                    JsonElement currO = jo.get(element);
                    if (currO == null) {
                        return Maybe.absent((String)("No element '" + element + " in JSON, when walking " + elements));
                    }
                    curr = Maybe.of((Object)currO);
                }
                return curr;
            }
        };
    }

    public static <T> Function<JsonElement, T> getPath(final String path) {
        return new Function<JsonElement, T>(){

            public T apply(JsonElement input) {
                String jsonString = input.toString();
                Object rawElement = JsonPath.read((String)jsonString, (String)path, (Predicate[])new Predicate[0]);
                return rawElement;
            }
        };
    }

    public static <T> Function<JsonElement, T> cast(final Class<T> expected) {
        return new Function<JsonElement, T>(){

            public T apply(JsonElement input) {
                if (input == null) {
                    return null;
                }
                if (input.isJsonNull()) {
                    return null;
                }
                if (expected == Boolean.TYPE || expected == Boolean.class) {
                    return input.getAsBoolean();
                }
                if (expected == Character.TYPE || expected == Character.class) {
                    return Character.valueOf(input.getAsCharacter());
                }
                if (expected == Byte.TYPE || expected == Byte.class) {
                    return input.getAsByte();
                }
                if (expected == Short.TYPE || expected == Short.class) {
                    return input.getAsShort();
                }
                if (expected == Integer.TYPE || expected == Integer.class) {
                    return input.getAsInt();
                }
                if (expected == Long.TYPE || expected == Long.class) {
                    return input.getAsLong();
                }
                if (expected == Float.TYPE || expected == Float.class) {
                    return Float.valueOf(input.getAsFloat());
                }
                if (expected == Double.TYPE || expected == Double.class) {
                    return input.getAsDouble();
                }
                if (expected == BigDecimal.class) {
                    return input.getAsBigDecimal();
                }
                if (expected == BigInteger.class) {
                    return input.getAsBigInteger();
                }
                if (Number.class.isAssignableFrom(expected)) {
                    return input.getAsNumber();
                }
                if (expected == String.class) {
                    return input.getAsString();
                }
                if (expected.isArray()) {
                    JsonArray array = input.getAsJsonArray();
                    Class<?> componentType = expected.getComponentType();
                    if (JsonElement.class.isAssignableFrom(componentType)) {
                        JsonElement[] result = new JsonElement[array.size()];
                        for (int i = 0; i < array.size(); ++i) {
                            result[i] = array.get(i);
                        }
                        return result;
                    }
                    Object[] result = (Object[])Array.newInstance(componentType, array.size());
                    for (int i = 0; i < array.size(); ++i) {
                        result[i] = JsonFunctions.cast(componentType).apply((Object)array.get(i));
                    }
                    return result;
                }
                throw new IllegalArgumentException("Cannot cast json element to type " + expected);
            }
        };
    }

    public static <T> Function<Maybe<JsonElement>, T> castM(Class<T> expected) {
        return Functionals.chain((Function)MaybeFunctions.get(), JsonFunctions.cast(expected));
    }

    public static <T> Function<Maybe<JsonElement>, T> castM(final Class<T> expected, final T defaultValue) {
        return new Function<Maybe<JsonElement>, T>(){

            public T apply(Maybe<JsonElement> input) {
                if (input.isAbsent()) {
                    return defaultValue;
                }
                return JsonFunctions.cast(expected).apply(input.get());
            }
        };
    }
}

