/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.event.feed.http;

import brooklyn.event.feed.http.JsonFunctions;
import brooklyn.util.guava.Functionals;
import brooklyn.util.http.HttpToolResponse;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Collection;

public class HttpValueFunctions {
    private HttpValueFunctions() {
    }

    public static Function<HttpToolResponse, Integer> responseCode() {
        return new Function<HttpToolResponse, Integer>(){

            public Integer apply(HttpToolResponse input) {
                return input.getResponseCode();
            }
        };
    }

    public static Function<HttpToolResponse, Boolean> responseCodeEquals(int expected) {
        return Functionals.chain(HttpValueFunctions.responseCode(), (Function)Functions.forPredicate((Predicate)Predicates.equalTo((Object)expected)));
    }

    public static Function<HttpToolResponse, Boolean> responseCodeEquals(int ... expected) {
        ArrayList expectedList = Lists.newArrayList();
        for (int e : expected) {
            expectedList.add(e);
        }
        return Functionals.chain(HttpValueFunctions.responseCode(), (Function)Functions.forPredicate((Predicate)Predicates.in((Collection)expectedList)));
    }

    public static Function<HttpToolResponse, String> stringContentsFunction() {
        return new Function<HttpToolResponse, String>(){

            public String apply(HttpToolResponse input) {
                return input.getContentAsString();
            }
        };
    }

    public static Function<HttpToolResponse, JsonElement> jsonContents() {
        return Functionals.chain(HttpValueFunctions.stringContentsFunction(), JsonFunctions.asJson());
    }

    public static <T> Function<HttpToolResponse, T> jsonContents(String element, Class<T> expected) {
        return HttpValueFunctions.jsonContents(new String[]{element}, expected);
    }

    public static <T> Function<HttpToolResponse, T> jsonContents(String[] elements, Class<T> expected) {
        return Functionals.chain(HttpValueFunctions.jsonContents(), JsonFunctions.walk(elements), JsonFunctions.cast(expected));
    }

    public static <T> Function<HttpToolResponse, T> jsonContentsFromPath(String path) {
        return Functionals.chain(HttpValueFunctions.jsonContents(), JsonFunctions.getPath(path));
    }

    public static Function<HttpToolResponse, Long> latency() {
        return new Function<HttpToolResponse, Long>(){

            public Long apply(HttpToolResponse input) {
                return input.getLatencyFullContent();
            }
        };
    }

    @Deprecated
    public static <A, B, C> Function<A, C> chain(Function<A, ? extends B> f1, Function<B, C> f2) {
        return Functionals.chain(f1, f2);
    }

    @Deprecated
    public static <A, B, C, D> Function<A, D> chain(Function<A, ? extends B> f1, Function<B, ? extends C> f2, Function<C, D> f3) {
        return Functionals.chain(f1, f2, f3);
    }

    @Deprecated
    public static <A, B, C, D, E> Function<A, E> chain(Function<A, ? extends B> f1, Function<B, ? extends C> f2, Function<C, ? extends D> f3, Function<D, E> f4) {
        return Functionals.chain(f1, f2, f3, f4);
    }
}

