/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.event.feed.http;

import brooklyn.event.AttributeSensor;
import brooklyn.event.feed.PollConfig;
import brooklyn.util.collections.MutableList;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.http.HttpTool;
import brooklyn.util.http.HttpToolResponse;
import brooklyn.util.time.Duration;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;
import javax.annotation.Nullable;

public class HttpPollConfig<T>
extends PollConfig<HttpToolResponse, T, HttpPollConfig<T>> {
    private String method = "GET";
    private String suburl = "";
    private Map<String, String> vars = ImmutableMap.of();
    private Map<String, String> headers = ImmutableMap.of();
    private byte[] body;
    private Duration connectionTimeout;
    private Duration socketTimeout;
    public static final Predicate<HttpToolResponse> DEFAULT_SUCCESS = new Predicate<HttpToolResponse>(){

        public boolean apply(@Nullable HttpToolResponse input) {
            return input != null && input.getResponseCode() >= 200 && input.getResponseCode() <= 399;
        }
    };

    public static <T> HttpPollConfig<T> forSensor(AttributeSensor<T> sensor) {
        return new HttpPollConfig<T>(sensor);
    }

    public static HttpPollConfig<Void> forMultiple() {
        return new HttpPollConfig<Void>(PollConfig.NO_SENSOR);
    }

    public HttpPollConfig(AttributeSensor<T> sensor) {
        super(sensor);
        super.checkSuccess(DEFAULT_SUCCESS);
    }

    public HttpPollConfig(HttpPollConfig<T> other) {
        super(other);
        this.suburl = other.suburl;
        this.vars = other.vars;
        this.method = other.method;
        this.headers = other.headers;
    }

    public String getSuburl() {
        return this.suburl;
    }

    public Map<String, String> getVars() {
        return this.vars;
    }

    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public Duration getSocketTimeout() {
        return this.socketTimeout;
    }

    public String getMethod() {
        return this.method;
    }

    public byte[] getBody() {
        return this.body;
    }

    public HttpPollConfig<T> method(String val) {
        this.method = val;
        return this;
    }

    public HttpPollConfig<T> suburl(String val) {
        this.suburl = val;
        return this;
    }

    public HttpPollConfig<T> vars(Map<String, String> val) {
        this.vars = val;
        return this;
    }

    public HttpPollConfig<T> headers(Map<String, String> val) {
        this.headers = val;
        return this;
    }

    public HttpPollConfig<T> body(byte[] val) {
        this.body = val;
        return this;
    }

    public HttpPollConfig<T> connectionTimeout(Duration val) {
        this.connectionTimeout = val;
        return this;
    }

    public HttpPollConfig<T> socketTimeout(Duration val) {
        this.socketTimeout = val;
        return this;
    }

    public URI buildUri(URI baseUri, Map<String, String> baseUriVars) {
        String uri = (baseUri != null ? baseUri.toString() : "") + (this.suburl != null ? this.suburl : "");
        Map<String, String> allvars = this.concat(baseUriVars, this.vars);
        if (allvars != null && allvars.size() > 0) {
            uri = uri + "?" + HttpTool.encodeUrlParams(allvars);
        }
        return URI.create(uri);
    }

    public Map<String, String> buildHeaders(Map<String, String> baseHeaders) {
        return MutableMap.builder().putAll(baseHeaders).putAll(this.headers).build();
    }

    private <K, V> Map<K, V> concat(Map<? extends K, ? extends V> map1, Map<? extends K, ? extends V> map2) {
        if (map1 == null || map1.isEmpty()) {
            return map2;
        }
        if (map2 == null || map2.isEmpty()) {
            return map1;
        }
        return MutableMap.builder().putAll(map1).putAll(map2).build();
    }

    @Override
    protected String toStringBaseName() {
        return "http";
    }

    @Override
    protected String toStringPollSource() {
        return this.suburl;
    }

    @Override
    protected MutableList<Object> equalsFields() {
        return super.equalsFields().appendIfNotNull((Object)this.method).appendIfNotNull(this.vars).appendIfNotNull(this.headers).appendIfNotNull((Object)this.body).appendIfNotNull((Object)this.connectionTimeout).appendIfNotNull((Object)this.socketTimeout);
    }
}

